package com.bxm.egg.user.facade;

import com.bxm.egg.user.facade.bo.UserTokenBO;
import com.bxm.egg.user.facade.service.UserTokenFacadeService;
import com.bxm.egg.user.token.TokenService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/19 1:25 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
@AllArgsConstructor
public class UserTokenFacadeServiceImpl implements UserTokenFacadeService {

    private TokenService tokenService;

    @Override
    public UserTokenBO renewToken(Long userId) {
        return tokenService.renewToken(userId);
    }
}