package com.bxm.egg.user.follow.impl;

import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.equitylevelmedal.impl.UserEquityLevelMedalServiceImpl;
import com.bxm.egg.user.follow.UserFollowService;
import com.bxm.egg.user.follow.UserRecommendFollowService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.integration.NewsIntegrationService;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.ImgDTO;
import com.bxm.egg.user.model.dto.NoteDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelMedalInfoDTO;
import com.bxm.egg.user.model.param.RecommendFollowUsersParam;
import com.bxm.egg.user.model.vo.RecommendFollowUsersVo;
import com.bxm.egg.user.model.vo.UserTag;
import com.bxm.egg.user.service.BlockUserService;
import com.bxm.egg.user.support.NativeUserService;
import com.bxm.egg.user.utils.ConstellationUtils;
import com.bxm.localnews.news.facade.dto.RecommendUserDTO;
import com.bxm.localnews.news.facade.param.RecommendQueryParam;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.sync.core.SyncCacheAgent;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

import static com.bxm.egg.user.constant.MemoryCacheKeyConfig.RECOMMEND_USER_CACHE_KEY;

/**
 * 用户推荐关注service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/22 4:28 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserRecommendFollowServiceImpl implements UserRecommendFollowService {
    private NewsIntegrationService newsIntegrationService;

    private NativeUserService nativeUserService;

    private UserTagService userTagService;

    private UserEquityLevelMedalServiceImpl userEquityLevelMedalService;

    private UserInfoCacheService userInfoCacheService;

    private UserFollowService userFollowService;

    private BlockUserService blockUserService;

    @Override
    public IPageModel<RecommendFollowUsersVo> getRecommendFollowUsers(RecommendFollowUsersParam param) {
        //获取已关注用户列表，应该是为了去掉这部分已经关注的用户
        List<Long> followedUserList = userFollowService.followUserIdList(param.getUserId());

        SyncCacheAgent<String, List<RecommendFollowUsersVo>> cacheAgent =
                SyncCacheHolderFactory.build(RECOMMEND_USER_CACHE_KEY, this::loadRecommendUserList);

        List<RecommendFollowUsersVo> recommendList = cacheAgent.get(param.getAreaCode());

        // 过滤当前用户和用户已经关注的用户
        recommendList = recommendList.stream().filter(recommendUser -> {
            return !followedUserList.contains(recommendUser.getUserId())
                    && !recommendUser.getUserId().equals(param.getUserId());
        }).collect(Collectors.toList());

        int start = (param.getPageNum() - 1) * param.getPageSize();
        int end = param.getPageNum() * param.getPageSize();

        if (start > recommendList.size()) {
            return new PageWarper<>(Lists.newArrayList());
        }

        if (end > recommendList.size()) {
            end = recommendList.size();
        }

        List<RecommendFollowUsersVo> pageResult = recommendList.subList(start, end);

        PlusPageModelDTO<RecommendFollowUsersVo> pageModelDTO = PlusPageModelDTO.build(null).changeList(pageResult);
        pageModelDTO.setLastPage(false);
        pageModelDTO.setHasNextPage(false);
        return pageModelDTO;
    }

    private List<RecommendFollowUsersVo> loadRecommendUserList(String areaCode) {
        List<RecommendFollowUsersVo> result = Lists.newArrayList();

        // 过滤掉黑名单用户
        Map<Long, Integer> blockUserMap = blockUserService.listBlockUser();

        for (int i = 1; i <= 5; i++) {
            RecommendQueryParam param = new RecommendQueryParam();
            param.setPageNum(i);
            param.setPageSize(500);
            param.setAreaCode(areaCode);

            List<RecommendUserDTO> recommendUserList = newsIntegrationService.recommendUserByPage(param);

            int querySize = recommendUserList.size();

            List<RecommendFollowUsersVo> list = recommendUserList.stream().filter(user -> {
                // 移除黑名单用户
                Integer blockType = blockUserMap.get(user.getUserId());
                return !Objects.equals(blockType, 1) && !Objects.equals(blockType, 2);
            }).map(this::convert).collect(Collectors.toList());

            List<Long> userIdList = list.stream().map(RecommendFollowUsersVo::getUserId).collect(Collectors.toList());

            // 填充数据
            fillRecommendUserInfo(list, userIdList);

            result.addAll(list);

            if (querySize < param.getPageSize()) {
                break;
            }
        }

        Collections.shuffle(result);

        return result;
    }

    private RecommendFollowUsersVo convert(RecommendUserDTO user) {
        List<ImgDTO> imgDTOList = Lists.newArrayList();

        if (user.getRecommendImgList() != null) {
            imgDTOList = user.getRecommendImgList().stream().map(imgDto -> {
                ImgDTO userImgDto = new ImgDTO();
                BeanUtils.copyProperties(imgDto, userImgDto);
                return userImgDto;
            }).limit(3).collect(Collectors.toList());
        }

        RecommendFollowUsersVo followUser = new RecommendFollowUsersVo();
        followUser.setUserId(user.getUserId());
        followUser.setImgInfo(imgDTOList);

        return followUser;
    }

    /**
     * 填充推荐用户信息
     *
     * @param list       推荐用户列表
     * @param userIdList 用户idList
     */
    private void fillRecommendUserInfo(List<RecommendFollowUsersVo> list, List<Long> userIdList) {
        if (!CollectionUtils.isEmpty(list)) {
            List<UserCacheInfoBO> userInfoList = userInfoCacheService.getBatchUserInfo(userIdList);

            //获取用户等级勋章信息
            List<UserEquityLevelMedalInfoDTO> equityLevelMedalList = userEquityLevelMedalService.getEquityLevelMedalList(userIdList);
            Map<Long, List<UserEquityLevelMedalInfoDTO>> equityMedalMap = equityLevelMedalList.stream().collect(Collectors.groupingBy(UserEquityLevelMedalInfoDTO::getUserId));
            //得到用户标签map
            Map<Long, List<UserTag>> userTagMap = userTagService.getBatchUserTag(userIdList);

            //得到用户帖子图片map
            AtomicReference<Map<Long, List<ImgDTO>>> imgMap = new AtomicReference<>(Maps.newHashMap());
            //得到用户纸条map
            AtomicReference<Map<Long, NoteDTO>> noteMap = new AtomicReference<>(Maps.newHashMap());

            list.forEach(recommendFollowUsersVo -> {
                Optional<UserCacheInfoBO> optional = userInfoList.stream()
                        .filter(user -> user.getUserId().equals(recommendFollowUsersVo.getUserId()))
                        .findFirst();
                if (optional.isPresent()) {
                    UserCacheInfoBO userInfo = optional.get();
                    recommendFollowUsersVo.setNickname(userInfo.getNickname());
                    recommendFollowUsersVo.setHeadImg(Objects.nonNull(userInfo.getHeadImg()) ? userInfo.getHeadImg() : null);
                    recommendFollowUsersVo.setSex(userInfo.getSex());
                    recommendFollowUsersVo.setFollowed(0);

                    fill(recommendFollowUsersVo, userInfo);

                    //星座 年龄段计算
                    if (Objects.nonNull(userInfo.getUserInformationBO()) && Objects.nonNull(userInfo.getUserInformationBO().getBirthday())) {
                        LocalDate birthday = userInfo.getUserInformationBO().
                                getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        recommendFollowUsersVo.setConstellation(ConstellationUtils.calculateConstellation(birthday));
                        recommendFollowUsersVo.setGeneration(nativeUserService.getGeneration(userInfo.getUserInformationBO().getBirthday()));
                    }

                    //组装帖子图片
                    List<ImgDTO> imgList = imgMap.get().get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty(imgList)) {
                        recommendFollowUsersVo.setImgInfo(imgList.size() > 3 ? imgList.subList(0, 3) : imgList);
                    }

                    //标签组装
                    List<String> userLabels = new ArrayList<>();
                    List<UserTag> userTagList = userTagMap.get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty(userTagList)) {
                        userLabels = userTagList.stream().filter(t -> t.getDeleteFlag() == 0).map(UserTag::getLabel)
                                .collect(Collectors.toList());
                    }
                    recommendFollowUsersVo.setUserLabels(userLabels);

                    //等级勋章设置
                    List<UserEquityLevelMedalInfoDTO> levelMedalInfoDTOS = equityMedalMap.get(recommendFollowUsersVo.getUserId());
                    if (!CollectionUtils.isEmpty(levelMedalInfoDTOS)) {
                        UserEquityLevelMedalInfoDTO userEquityLevelMedalInfoDTO = levelMedalInfoDTOS.get(0);
                        recommendFollowUsersVo.setUserWarmLevelDTO(userEquityLevelMedalInfoDTO.getUserEquityDTO());
                    }
                }
            });
        }
    }

    private void fill(RecommendFollowUsersVo recommendFollowUsersVo, UserCacheInfoBO userInfo) {
        if (Objects.nonNull(userInfo.getUserInformationBO()) && Objects.nonNull(userInfo.getUserInformationBO().getPersonalProfile())) {
            recommendFollowUsersVo.setDesc(userInfo.getUserInformationBO().getPersonalProfile());
        } else {
            recommendFollowUsersVo.setDesc("TA还没有介绍自己");
        }
    }
}





















