package com.bxm.egg.user.info;

import com.bxm.egg.user.facade.param.UserStatisticsOperateParam;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.newidea.component.bo.Message;

/**
 * 用户统计信息服务
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 5:35 下午
 */
public interface UserStatisticsService {

    /**
     * 根据用户id查询用户的统计值信息
     *
     * @param userId 用户id
     * @return 统计值信息
     */
    UserStatisticsEntity selectUserStatisticsByUserId(Long userId);

    /**
     * 更新用户的温暖值（温暖值最小为0）
     *
     * @param userId           用户id
     * @param warmValue        温暖值
     * @param defaultWarmValue 默认的最小温暖值
     * @return 结果
     */
    int updateUserWarmInfo(Long userId,
                           Integer warmValue,
                           Integer defaultWarmValue);

    /**
     * 操作用户统计数据
     *
     * @param param 入参
     * @return 操作结果
     */
    Message operateUserStatistics(UserStatisticsOperateParam param);

}