package com.bxm.egg.user.invite;

import com.bxm.egg.user.model.dto.BountyDTO;
import com.bxm.egg.user.model.dto.UserPayPromoteDTO;
import com.bxm.egg.user.model.vo.InviteRecord;
import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/5 22:13
 * @desc
 */
public interface InviteRecordService {

    /**
     * 获取用户未到账金额详情
     */
    BountyDTO getUserBountyInfo(Long userId);

    /**
     * 获取推广赚钱信息
     */
    UserPayPromoteDTO getUserPayPromote(Long userId);

    /**
     * 添加邀请关系
     *
     * @param inviteUserId 邀请人id
     * @param invitedUserId 受邀人id
     * @param type 邀请途径
     */
    Long addInviteRecord(Long inviteUserId, Long invitedUserId, String type);

    /**
     * 更新邀请关系金额
     *
     * @param inviteUserId 邀请人id
     * @param invitedUserId 受邀人id
     * @param cash 邀请金额
     */
    Long updateInviteCash(Long inviteUserId, Long invitedUserId, BigDecimal cash);

    /**
     * 根据邀请人和受邀人获取邀请关系
     *
     * @param inviteUserId 邀请人用户id
     * @param invitedUserId 受邀人用户id
     */
    InviteRecord getInviteRecordByInvitedUser(Long inviteUserId, Long invitedUserId);

    /**
     * 更新用户邀请关系
     */
    Boolean updateInviteRecord(InviteRecord inviteRecord);

    /**
     * 根据邀请人和id获取邀请关系
     *
     * @param inviteUserId 邀请人用户id
     * @param id 邀请关系id
     */
    InviteRecord getInviteRecordById(Long inviteUserId, Long id);

    /**
     * 判断是否是协会人员
     */
    Boolean checkIsAssociation(Long userId);

    /**
     * 新增邀请记录
     * @param inviteUserId ： 邀请人
     * @param invitedUserId ： 被邀请人
     * @return ： 新增确定的邀请记录
     */
    Boolean insertNormal(Long inviteUserId, Long invitedUserId);
}
