package com.bxm.egg.user.invite.egg;

import com.bxm.egg.user.model.dto.invite.RollBarrageDTO;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.entity.TempInviteBindEntity;
import com.bxm.egg.user.model.param.invite.InviteBindParam;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.newidea.component.dto.IPageModel;

import java.util.Date;
import java.util.List;

/**
 * 蛋蛋佳用户邀请service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/24 5:11 下午
 */
public interface UserEggInviteService {

    /**
     * 分页获取用户邀请列表
     *
     * @param invitePageParam 入参
     * @return 分页邀请数据
     */
    IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam);

    /**
     * 获取邀请用户id
     *
     * @param userId 用户id
     * @return 邀请用户id
     */
    Long getInviteUserId(Long userId);

    /**
     * 统计邀请好友的个数
     *
     * @param userId 用户id
     * @return 邀请好友的个数
     */
    int countInviteUser(Long userId);

    /**
     * 获取用户邀请好友的最近五个头像列表
     *
     * @param userId 用户id
     * @return 头像列表
     */
    List<String> getUserInviteHeadImgList(Long userId);

    /**
     * 获取滚动弹幕
     *
     * @return 弹幕列表
     */
    List<RollBarrageDTO> getRollBarrage();

    /**
     * 临时绑定邀请关系
     *
     * @param inviteBindParam 入参
     * @return 是否绑定成功
     */
    Boolean tempBindInvite(InviteBindParam inviteBindParam);

    /**
     * 获取用户临时绑定信息
     *
     * @param unionId 入参
     * @return 绑定信息
     */
    TempInviteBindEntity getUserTempBindInvite(String unionId);


    /**
     * 删除临时邀请关系
     *
     * @param unionId 微信的唯一标识
     */
    void delInviteBindByUnionId(String unionId);

    /**
     * 删除临时邀请关系
     *
     * @param date 删除此时间之前的临时信息
     */
    void delInviteBindByDate(Date date);

    Integer getReceiveContributeFoods(Long userId);

    Boolean receiveFoods(Long userId);
}