package com.bxm.egg.user.invite.egg.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.integration.sync.SixEnjoyDataStatisticsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyFriendsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyInviteFoodsIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.EggInviteMapper;
import com.bxm.egg.user.mapper.TempInviteBindMapper;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.invite.RollBarrageDTO;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import com.bxm.egg.user.model.entity.TempInviteBindEntity;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.param.invite.InviteBindParam;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.config.XxlJobConfiguration;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.sync.facade.dto.UserTodayContributionDTO;
import com.bxm.sync.facade.dto.UserUseEggNumDTO;
import com.bxm.sync.facade.service.SixEnjoyDataStatisticsService;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 蛋蛋佳用户邀请service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/24 5:19 下午
 */
@Slf4j
@Service
public class UserEggInviteServiceImpl implements UserEggInviteService {

    @Autowired
    private EggInviteMapper eggInviteMapper;
    @Autowired
    private UserProperties userProperties;
    @Autowired
    private TempInviteBindMapper tempInviteBindMapper;
    @Autowired
    private SixEnjoyInviteFoodsIntegrationService inviteFoodsIntegrationService;
    @Autowired
    private SixEnjoyDataStatisticsIntegrationService statisticsIntegrationService;
    @Autowired
    private UserInfoCacheService userInfoCacheService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private UserWechatGrantService userWechatGrantService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private SixEnjoyFriendsIntegrationService sixEnjoyFriendsIntegrationService;

    @Override
    public IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam) {
        Page<InviteUserListDTO> page = new Page<>(invitePageParam.getPageNum(), invitePageParam.getPageSize());
        page.setSearchCount(false);

        if (null == invitePageParam.getUserId()) {
            return PlusPageModelDTO.build(null);
        }
        // 查询邀请的用户和赠送的粮食
        IPage<InviteUserListDTO> result = eggInviteMapper.queryInviteByPage(page, invitePageParam.getUserId());

        // 查询同步服务，获取用户今日贡献的粮食
        List<Long> userIdList = result.getRecords().stream().map(InviteUserListDTO::getUserId).collect(Collectors.toList());
        List<UserTodayContributionDTO> userFoodsList = inviteFoodsIntegrationService.getTodayContribution(userIdList);

        result.getRecords().forEach(inviteUser -> {
            UserCacheInfoBO cacheInfoBO = userInfoCacheService.load(inviteUser.getUserId());

            inviteUser.setHeadImg(cacheInfoBO.getHeadImg());
            inviteUser.setNickName(cacheInfoBO.getNickname());

            if (null == inviteUser.getHasEggNum()) {
                inviteUser.setHasEggNum(0);
            }

            Optional<UserTodayContributionDTO> userFoodValue = userFoodsList.stream()
                    .filter(userFood -> Objects.equals(inviteUser.getUserId(), userFood.getUserId()))
                    .findFirst();

            if (userFoodValue.isPresent()) {
                inviteUser.setContributeFoodsNum(userFoodValue.get().getFoodNum());
                inviteUser.setContributeAllFoodsNum(userFoodValue.get().getAllFoodNum());
            } else {
                inviteUser.setContributeFoodsNum(0);
                inviteUser.setContributeAllFoodsNum(0);
            }
        });
        List<InviteUserListDTO> collect = result.getRecords().stream()
                .sorted(Comparator.comparing(InviteUserListDTO::getContributeFoodsNum).reversed()).collect(Collectors.toList());
        result.setRecords(collect);
        PlusPageModelDTO<InviteUserListDTO> pageModelDTO = PlusPageModelDTO.build(result);
        if (result.getRecords().size() == invitePageParam.getPageSize()) {
            pageModelDTO.setHasNextPage(true);
            pageModelDTO.setLastPage(false);
        } else {
            pageModelDTO.setHasNextPage(false);
            pageModelDTO.setLastPage(true);
        }

        return pageModelDTO;
    }

    @Override
    public Long getInviteUserId(Long userId) {
        LambdaQueryWrapper<EggInviteEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(EggInviteEntity::getBeInviteUserId, userId);
        EggInviteEntity eggInviteEntity = eggInviteMapper.selectOne(queryWrapper);

        if (eggInviteEntity != null) {
            return eggInviteEntity.getUserId();
        }
        return null;
    }

    @Override
    public int countInviteUser(Long userId) {
        LambdaQueryWrapper<EggInviteEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(EggInviteEntity::getUserId, userId);

        return eggInviteMapper.selectCount(queryWrapper);
    }

    @Override
    public List<String> getUserInviteHeadImgList(Long userId) {
        return eggInviteMapper.getInviteUserHeadImg(userId, userProperties.getInviteHeadImgNum());
    }

    @Override
    public List<RollBarrageDTO> getRollBarrage() {

        List<RollBarrageDTO> rollBarrageDTOS = redisStringAdapter.get(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy(), new TypeReference<List<RollBarrageDTO>>() {
        });
        if (rollBarrageDTOS != null && rollBarrageDTOS.size() > 0) {
            return rollBarrageDTOS;
        }
        List<UserUseEggNumDTO> userUseEggNumMaxList = statisticsIntegrationService.getUserUseEggNumMaxList();
        List<RollBarrageDTO> rollBarrageDTOList = userUseEggNumMaxList.stream().map(userUseEggNumDTO -> {
            UserCacheInfoBO cacheInfoBO = userInfoCacheService.load(userUseEggNumDTO.getUserId());
            String nickname = cacheInfoBO.getNickname();
            return RollBarrageDTO.builder()
                    .eggNums(userUseEggNumDTO.getUseEggNum())
                    .nickname(StringUtils.hideRealName(nickname))
                    .build();
        }).collect(Collectors.toList());
        redisStringAdapter.set(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy(), rollBarrageDTOList);
        redisStringAdapter.expire(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy(), DateUtils.getCurSeconds());
        return rollBarrageDTOList;
    }

    @Override
    public Boolean tempBindInvite(InviteBindParam inviteBindParam) {

        boolean lock = distributedLock.lock(inviteBindParam.getUnionId() + inviteBindParam.getUserId());
        if (!lock) {
            log.info("出现重复点击，请求参数：{}", JSON.toJSONString(inviteBindParam));
            return Boolean.FALSE;
        }
        Optional<UserGrantWechatAppEntity> userGrantWechatAppEntity = userWechatGrantService.userInfoUnionIdExist(inviteBindParam.getUnionId());

        if (userGrantWechatAppEntity.isPresent()) {
            //如果被邀请人已注册APP，则只建立好友关系
            sixEnjoyFriendsIntegrationService.insertFriendsToSixEnjoy(inviteBindParam.getUserId(), userGrantWechatAppEntity.get().getUserId());
        } else {
            delInviteBindByUnionId(inviteBindParam.getUnionId());
            //建立新的邀请关系
            TempInviteBindEntity tempInviteBindEntity = new TempInviteBindEntity();
            tempInviteBindEntity.setId(sequenceCreater.nextLongId());
            tempInviteBindEntity.setUnionId(inviteBindParam.getUnionId());
            tempInviteBindEntity.setUserId(inviteBindParam.getUserId());
            tempInviteBindEntity.setSource(inviteBindParam.getSource());
            tempInviteBindEntity.setCreateTime(new Date());
            tempInviteBindMapper.insert(tempInviteBindEntity);
        }
        distributedLock.unlock(inviteBindParam.getUnionId() + inviteBindParam.getUserId());
        return Boolean.TRUE;
    }

    @Override
    public TempInviteBindEntity getUserTempBindInvite(String unionId) {
        LambdaQueryWrapper<TempInviteBindEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TempInviteBindEntity::getUnionId, unionId);
        return tempInviteBindMapper.selectOne(queryWrapper);
    }

    @Override
    public void delInviteBindByUnionId(String unionId) {
        //删除老的临时邀请关系，建立新的邀请关系
        tempInviteBindMapper.delInviteBindByUnionId(unionId);
    }

    @Override
    public void delInviteBindByDate(Date date) {
        //删除老的临时邀请关系，建立新的邀请关系
        tempInviteBindMapper.delInviteBindByDate(date);
    }

    @Override
    public Integer getReceiveContributeFoods(Long userId) {
        return 0;
    }

    @Override
    public Boolean receiveFoods(Long userId) {
        return Boolean.TRUE;
    }
}