package com.bxm.egg.user.invite.processor;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.dto.CommodityGoodsDTO;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.egg.user.utils.MaxLengthStringBuilder;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 分享返利商品形成邀请关系
 *
 * @author liujia
 * @date 2020/05/11 20:54
 */
@Component
public class RebateInviteTypeProcessor extends AbstractInviteTypeProcessor {


    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return StringUtils.EMPTY;
        }

        CommodityGoodsDTO goods = null;

        if (null != goods && StringUtils.isNotBlank(goods.getCommodityTitle())) {
            return goods.getCommodityTitle();
        }

        return StringUtils.EMPTY;
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.REBATE;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank(inviteHistory.getRelationTitle())) {
            return defaultInviteMsg;
        }

        return MaxLengthStringBuilder.builder(defaultColumnWidth)
                .appendImmutable("分享的《")
                .appendDynamic(inviteHistory.getRelationTitle())
                .appendImmutable("》商品")
                .build();
    }
}
