package com.bxm.egg.user.location;

import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.param.UserHomeTownParam;

/**
 * 用户定位信息service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 11:09 上午
 */
public interface UserLocationService {

    /**
     * 根据用户id获取用户的定位信息
     *
     * @param userId 用户id
     * @return 用户的定位信息
     */
    UserLocationEntity getUserLocationByUserId(Long userId);

    /**
     * 更新用户的家乡信息
     *
     * @param userHomeTownParam 入参
     * @return 影响行数
     */
    int updateUserHometownInfo(UserHomeTownParam userHomeTownParam);


    /**
     * 更新用户的定位信息
     *
     * @param userId       用户id
     * @param locationCode 地区编码
     * @param locationName 地区名称
     * @return 影响行数
     */
    int updateUserLocationInfo(Long userId,
                               String locationCode,
                               String locationName);


    /**
     * 更新用户定位信息通过
     *
     * @param userId             用户id
     * @param userLocationEntity 更新用户信息
     * @return 影响行数
     */
    int updateUserLocationInfo(Long userId,
                               UserLocationEntity userLocationEntity);
}