package com.bxm.egg.user.location.event;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/27 1:51 下午
 */
@Data
@Builder
@AllArgsConstructor
public class UserLocationReportEvent {

    @Tolerate
    public UserLocationReportEvent() {

    }

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("地区简称")
    private String areaName;

    @ApiModelProperty("经度")
    private BigDecimal lng;

    @ApiModelProperty("纬度")
    private BigDecimal lat;
}