package com.bxm.egg.user.login.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.facade.param.UserWarmActionParam;
import com.bxm.egg.user.login.UserLogService;
import com.bxm.egg.user.login.event.LoginEvent;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.warmlevel.impl.WarmHandlerProxy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/19 9:24 下午
 */
@Slf4j
@Component
public class LoginListener {

    @Resource
    private UserLogService userLogService;

    @Resource
    private WarmHandlerProxy warmHandlerProxy;

    @Resource
    private UserProperties userProperties;

    @EventListener
    @Async
    public void userLoginEvent(LoginEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("监听到用户登录事件，事件内容: {}", JSON.toJSONString(event));
        }
        //记录登录日志
        userLogService.recordLoginLog(event.getLoginParam(), event.getLoginResult(), event.getLoginType());
        //登录发放温暖
        UserWarmActionParam userWarmActionParam = UserWarmActionParam.builder()
                .userId(event.getUserId())
                .warmRuleEnum(WarmRuleEnum.LOGIN)
                .warmValue(userProperties.getLoginWarmValue())
                .build();
        warmHandlerProxy.handle(userWarmActionParam);
    }
}