package com.bxm.egg.user.timer;

import com.bxm.egg.user.constant.UserBizConfigProperties;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 定时清理临时邀请关系
 *
 * @author lowi
 */
@Component
@Slf4j
public class DelTempInviteTask extends AbstractCronXxlJob {

    @Autowired
    UserBizConfigProperties userBizConfigProperties;

    @Autowired
    UserEggInviteService userEggInviteService;

    @Override
    protected void executeLogic() {
        Date date = DateUtils.addDays(new Date(), userBizConfigProperties.getDelTempInviteDayNum() * -1);
        userEggInviteService.delInviteBindByDate(date);
    }


    @Override
    public String cron() {
        return "0 0 0 * * ?";
    }

    @Override
    public String jobDesc() {
        return "每天凌晨定时清理临时邀请关系";
    }

    @Override
    public String author() {
        return "耿杨杨";
    }

}
