package com.bxm.egg.user.timer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.common.enums.AuthCodeEnum;
import com.bxm.egg.user.auth.UserAuthCodeService;
import com.bxm.egg.user.auth.UserBlockExpiredTaskService;
import com.bxm.egg.user.model.entity.UserBlockExpiredTaskEntity;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/17 5:43 下午
 */
@Component
@Slf4j
public class UserBlockExpiredTimeTask extends AbstractCronXxlJob {

    @Resource
    private UserBlockExpiredTaskService userBlockExpiredTaskService;

    @Resource
    private UserAuthCodeService userAuthCodeService;

    @Override
    public String cron() {
        return "0 0/1 * * * ?";
    }

    @Override
    protected void executeLogic() {
        List<UserBlockExpiredTaskEntity> expiredTaskList = userBlockExpiredTaskService.getExpiredTaskList();

        if (log.isDebugEnabled()) {
            log.debug("执行用户违规处理定时任务==========");
        }

        if (!CollectionUtils.isEmpty(expiredTaskList)) {
            for (UserBlockExpiredTaskEntity userBlockExpiredTaskEntity : expiredTaskList) {
                List<Integer> authCodeIndex = JSON.parseArray(userBlockExpiredTaskEntity.getAuthIndex(), Integer.class);
                authCodeIndex.forEach(index -> {
                    AuthCodeEnum codeEnum = AuthCodeEnum.getByIndex(index);
                    if (Objects.nonNull(codeEnum)) {
                        userAuthCodeService.removeAuthCode(userBlockExpiredTaskEntity.getUserId(), codeEnum);
                    }
                });
                if (log.isDebugEnabled()) {
                    log.debug("移除用户权限定任务执行成功,任务数据:[{}]", JSONObject.toJSONString(userBlockExpiredTaskEntity));
                }

                //执行后就把这个任务删除掉
                userBlockExpiredTaskService.removeTask(userBlockExpiredTaskEntity.getUserId());
            }
        }
    }

    @Override
    public String jobDesc() {
        return "用户违规处理定时任务";
    }

    @Override
    public String author() {
        return "王志远";
    }
}