package com.bxm.egg.user.warmlevel.impl.rule;

import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.newidea.component.bo.Message;

/**
 * 用户获取温暖值规则
 *
 * @author lowi
 * @date 2021/3/3 11:22
 */
public interface WarmRule {


    /**
     * 执行规则
     *
     * @param context 上下文
     * @return 执行结果，true表示验证通过
     */
    Message apply(WarmActionContext context);

    /**
     * 规则验证失败的情况下是否允许重试，默认直接失败
     * 如果验证可能涉及到锁或资源竞争，可以允许重试
     *
     * @return true表示规则验证失败时进入重试
     */
    default boolean retryOnFailed() {
        return false;
    }
}
