/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.account.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.facade.enums.OperateTypeEnum;
import com.bxm.egg.user.integration.sync.SixEnjoyDataStatisticsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserAccountIntegrationService;
import com.bxm.egg.user.mapper.UserAccountMapper;
import com.bxm.egg.user.model.dto.account.UserBaseAccountInfoDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.sync.facade.dto.UserCouponsStatisticsDTO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserAccountServiceImpl
implements UserAccountService {
    private static final Logger log = LoggerFactory.getLogger(UserAccountServiceImpl.class);
    private final UserAccountMapper userAccountMapper;
    private final SixEnjoyDataStatisticsIntegrationService sixEnjoyDataStatisticsIntegrationService;
    private final SixEnjoyUserAccountIntegrationService sixEnjoyUserAccountIntegrationService;

    @Override
    public UserBaseAccountInfoDTO baseInfo(Long userId) {
        UserAccountEntity userAccountEntity = this.getUserAccountInfo(userId);
        UserCouponsStatisticsDTO couponsStatistics = this.sixEnjoyDataStatisticsIntegrationService.getCouponsStatistics(userId);
        return UserBaseAccountInfoDTO.builder().userId(userId).usableEggCouponNum(couponsStatistics.getEggCoupon()).usableEggNum(userAccountEntity.getUsableEgg()).build();
    }

    @Override
    public UserAccountEntity getUserAccountInfo(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserAccountEntity::getUserId, (Object)userId);
        UserAccountEntity userAccountEntity = (UserAccountEntity)this.userAccountMapper.selectOne((Wrapper)queryWrapper);
        if (userAccountEntity == null) {
            return this.buildInvalidUserAccount(userId);
        }
        return userAccountEntity;
    }

    @Override
    public Boolean operateEgg(Long userId, Integer num, Integer type) {
        if (Objects.equals(OperateTypeEnum.INCREASE.getCode(), type)) {
            return this.sixEnjoyUserAccountIntegrationService.addEggsNum(userId, num, "\u706b\u5566\u6d4b\u8bd5\u64cd\u4f5c");
        }
        if (Objects.equals(OperateTypeEnum.REDUCE.getCode(), type)) {
            return this.sixEnjoyUserAccountIntegrationService.subEggsNum(userId, num, "\u706b\u5566\u6d4b\u8bd5\u64cd\u4f5c");
        }
        return false;
    }

    @Override
    public Boolean operateFoods(Long userId, Integer num, Integer type) {
        if (Objects.equals(OperateTypeEnum.INCREASE.getCode(), type)) {
            return this.sixEnjoyUserAccountIntegrationService.addFoodsNum(userId, num, "\u706b\u5566\u6d4b\u8bd5\u64cd\u4f5c");
        }
        if (Objects.equals(OperateTypeEnum.REDUCE.getCode(), type)) {
            return this.sixEnjoyUserAccountIntegrationService.subFoodsNum(userId, num, "\u706b\u5566\u6d4b\u8bd5\u64cd\u4f5c");
        }
        return false;
    }

    private UserAccountEntity buildInvalidUserAccount(Long userId) {
        UserAccountEntity userAccountEntity = new UserAccountEntity();
        userAccountEntity.setId(Long.valueOf(0L));
        userAccountEntity.setUserId(userId);
        userAccountEntity.setMoney(new BigDecimal("0"));
        userAccountEntity.setEggCoin(new BigDecimal("0"));
        userAccountEntity.setCompanyMoney(new BigDecimal("0"));
        userAccountEntity.setScore(Integer.valueOf(0));
        userAccountEntity.setAllFoods(Integer.valueOf(0));
        userAccountEntity.setUsableFoods(Integer.valueOf(0));
        userAccountEntity.setUsedFoods(Integer.valueOf(0));
        userAccountEntity.setAllEgg(Integer.valueOf(0));
        userAccountEntity.setUsableEgg(Integer.valueOf(0));
        userAccountEntity.setUsedEgg(Integer.valueOf(0));
        userAccountEntity.setCreateTime(LocalDateTime.now());
        userAccountEntity.setModifyTime(LocalDateTime.now());
        return userAccountEntity;
    }

    public UserAccountServiceImpl(UserAccountMapper userAccountMapper, SixEnjoyDataStatisticsIntegrationService sixEnjoyDataStatisticsIntegrationService, SixEnjoyUserAccountIntegrationService sixEnjoyUserAccountIntegrationService) {
        this.userAccountMapper = userAccountMapper;
        this.sixEnjoyDataStatisticsIntegrationService = sixEnjoyDataStatisticsIntegrationService;
        this.sixEnjoyUserAccountIntegrationService = sixEnjoyUserAccountIntegrationService;
    }
}

