/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.attribute.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.mapper.UserCommonTagMapper;
import com.bxm.egg.user.mapper.UserTagMapper;
import com.bxm.egg.user.model.dto.UserTagDTO;
import com.bxm.egg.user.model.vo.UserCommonTag;
import com.bxm.egg.user.model.vo.UserTag;
import com.bxm.egg.user.model.vo.UserTagRedis;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserTagServiceImpl
implements UserTagService {
    private final UserCommonTagMapper userCommonTagMapper;
    private final UserTagMapper userTagMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public List<UserTagDTO> listUserTag(Long userId) {
        List<UserCommonTag> commonTagList = ((UserTagServiceImpl)SpringContextHolder.getBean(this.getClass())).listUserCommonTag();
        List<UserTag> userTagList = this.getUserTagFromRedisDb(userId);
        ArrayList<UserTagDTO> userTagDtoList = new ArrayList<UserTagDTO>();
        HashSet labelList = new HashSet();
        userTagList.forEach(e -> {
            userTagDtoList.add(this.convertUserTag2UserTagDto((UserTag)e));
            labelList.add(e.getLabel());
        });
        commonTagList.forEach(e -> {
            if (!labelList.contains(e.getLabel())) {
                userTagDtoList.add(this.convertUserCommonTag2UserTagDto((UserCommonTag)e));
            }
        });
        return userTagDtoList;
    }

    @Override
    public UserTagDTO convertUserTag2UserTagDto(UserTag userTag) {
        UserTagDTO userTagDTO = new UserTagDTO();
        userTagDTO.setChooseFlag(Byte.valueOf((byte)(userTag.getDeleteFlag() == 0 ? 1 : 0)));
        userTagDTO.setDefaultFlag(userTag.getDefaultFlag());
        userTagDTO.setId(userTag.getId());
        userTagDTO.setLabel(userTag.getLabel());
        userTagDTO.setOrder(userTag.getOrder());
        return userTagDTO;
    }

    @Override
    public Map<Long, List<UserTag>> getBatchUserTag(Collection<Long> userIds) {
        HashMap<Long, List<UserTag>> userTagMap = new HashMap<Long, List<UserTag>>();
        List paramList = userIds.stream().map(String::valueOf).collect(Collectors.toList());
        List userTagCaches = this.redisHashMapAdapter.multiGet(RedisConfig.USER_TAG, paramList, String.class);
        userTagCaches.forEach(e -> {
            UserTagRedis userTagRedis = (UserTagRedis)JSON.parseObject((String)e, UserTagRedis.class);
            if (null != userTagRedis) {
                userTagMap.put(userTagRedis.getUserId(), userTagRedis.getUserTagList());
            }
        });
        return userTagMap;
    }

    private UserTagDTO convertUserCommonTag2UserTagDto(UserCommonTag userTag) {
        UserTagDTO userTagDTO = new UserTagDTO();
        userTagDTO.setChooseFlag(Byte.valueOf((byte)0));
        userTagDTO.setDefaultFlag(Byte.valueOf((byte)1));
        userTagDTO.setId(userTag.getId());
        userTagDTO.setLabel(userTag.getLabel());
        return userTagDTO;
    }

    @Override
    @Cacheable(value={"listUserCommonTag"}, sync=true)
    public List<UserCommonTag> listUserCommonTag() {
        return this.userCommonTagMapper.selectAll();
    }

    @Override
    public List<UserTag> getUserTagFromRedisDb(Long userId) {
        List userTagList;
        String userTagStr = (String)this.redisHashMapAdapter.get(RedisConfig.USER_TAG, String.valueOf(userId), String.class);
        if (!StringUtils.isEmpty((Object)userTagStr)) {
            UserTagRedis userTagRedis = (UserTagRedis)JSON.parseObject((String)userTagStr, UserTagRedis.class);
            userTagList = userTagRedis.getUserTagList();
        } else {
            userTagList = this.userTagMapper.selectByUserId(userId);
            UserTagRedis userTagRedis = CollectionUtils.isEmpty((Collection)userTagList) ? UserTagRedis.buildEmptyUserTagRedis((Long)userId) : UserTagRedis.buildUserTagRedis((Long)userId, (List)userTagList);
            this.redisHashMapAdapter.put(RedisConfig.USER_TAG, String.valueOf(userId), (Object)JSON.toJSONString((Object)userTagRedis));
        }
        return userTagList;
    }

    public UserTagServiceImpl(UserCommonTagMapper userCommonTagMapper, UserTagMapper userTagMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.userCommonTagMapper = userCommonTagMapper;
        this.userTagMapper = userTagMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }
}

