/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.attribute.UserPersonalInfoService;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.info.UserExtendService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.location.event.UserLocationChangeEvent;
import com.bxm.egg.user.mapper.UserAccountMapper;
import com.bxm.egg.user.mapper.UserInformationMapper;
import com.bxm.egg.user.mapper.UserLocationMapper;
import com.bxm.egg.user.mapper.UserStatisticsMapper;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.utils.FileMd5Util;
import com.bxm.newidea.component.oss.config.AliyunOssProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserExtendServiceImpl
implements UserExtendService {
    private static final Logger log = LoggerFactory.getLogger(UserExtendServiceImpl.class);
    private AliyunOSSService aliyunOSSService;
    private UserProperties userProperties;
    private CommonProperties commonProperties;
    private AliyunOssProperties aliyunOssProperties;
    private SequenceCreater sequenceCreater;
    private UserInformationMapper userInformationMapper;
    private UserStatisticsMapper userStatisticsMapper;
    private UserLocationMapper userLocationMapper;
    private UserAccountMapper userAccountMapper;
    private LocationIntegrationService locationIntegrationService;
    private UserPersonalInfoService userPersonalInfoService;
    private UserInformationService userInformationService;
    private UserLocationService userLocationService;
    private UserInfoService userInfoService;

    @Override
    public String uploadWechatImage(String headImg, BasicParam param, Long userId) {
        if (null == headImg) {
            headImg = this.userProperties.getDefaultHeadImageUrl();
            return headImg;
        }
        if (headImg.startsWith(this.aliyunOssProperties.getCdnUrl())) {
            return headImg;
        }
        try {
            if (StringUtils.endsWith((CharSequence)headImg, (CharSequence)"132")) {
                headImg = headImg.substring(0, headImg.length() - 3) + "0";
            } else if (StringUtils.endsWith((CharSequence)headImg, (CharSequence)"96") || StringUtils.endsWith((CharSequence)headImg, (CharSequence)"64") || StringUtils.endsWith((CharSequence)headImg, (CharSequence)"46")) {
                headImg = headImg.substring(0, headImg.length() - 2) + "0";
            }
            URL url = new URL(headImg);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;
            if (conn.getResponseCode() == HttpStatus.OK.value()) {
                inputStream = conn.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(buf)) >= 0) {
                    baos.write(buf, 0, n);
                }
                byte[] content = baos.toByteArray();
                String md5 = FileMd5Util.getMd5(content);
                if (this.commonProperties.getEmptyHeadImgFileMd5().contains(md5)) {
                    return this.userProperties.getDefaultHeadImageUrl();
                }
                inputStream = new ByteArrayInputStream(content);
                log.debug("\u6839\u636eurl\u83b7\u5f97\u56fe\u7247\u7684\u6d41\u72b6\u6001\uff1a{}", (Object)inputStream.available());
            }
            if (userId == null) {
                userId = SequenceHolder.nextLongId();
            }
            int hashCode = (int)(userId % 100L);
            String path = "";
            if (null != param.getSrcApp()) {
                path = param.getSrcApp() + "/";
            }
            String datePath = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
            path = path + "avatar/" + datePath + hashCode + "/" + Long.toHexString(userId) + ".jpeg";
            return this.aliyunOSSService.upload(inputStream, path) + "?x-oss-process=style/head";
        }
        catch (IOException e) {
            log.error("\u5fae\u4fe1\u6388\u6743\u4e0a\u4f20\u5934\u50cf\u51fa\u9519\uff0c\u4f7f\u7528\u9ed8\u8ba4\u5934\u50cf\uff0c\u7528\u6237id:[{}],\u7528\u6237\u5934\u50cf:[{}],\u9519\u8bef:[{}]", new Object[]{userId, headImg, e.getMessage()});
            headImg = this.userProperties.getDefaultHeadImageUrl();
            return headImg;
        }
    }

    @Override
    public void initUserExtendData(UserInfoEntity newUser) {
        UserInformationEntity newUserInformation = new UserInformationEntity();
        newUserInformation.setId(this.sequenceCreater.nextLongId());
        newUserInformation.setUserId(newUser.getId());
        this.userInformationMapper.insert((Object)newUserInformation);
        UserStatisticsEntity newUserStatisticsEntity = new UserStatisticsEntity();
        newUserStatisticsEntity.setId(this.sequenceCreater.nextLongId());
        newUserStatisticsEntity.setUserId(newUser.getId());
        this.userStatisticsMapper.insert((Object)newUserStatisticsEntity);
        UserLocationEntity newUserLocationEntity = new UserLocationEntity();
        newUserLocationEntity.setId(this.sequenceCreater.nextLongId());
        newUserLocationEntity.setUserId(newUser.getId());
        LocationDTO defaultLocationDTO = this.locationIntegrationService.getLocationByGeocode(this.userProperties.getDefaultLocationCode());
        if (defaultLocationDTO != null) {
            newUserLocationEntity.setLocationCode(this.userProperties.getDefaultLocationCode());
            newUserLocationEntity.setLocationName(defaultLocationDTO.getName());
            SpringContextHolder.getApplicationContext().publishEvent((Object)UserLocationChangeEvent.builder().areaCode(this.userProperties.getDefaultLocationCode()).areaName(defaultLocationDTO.getName()).userId(newUser.getId()).build());
        }
        this.userLocationMapper.insert((Object)newUserLocationEntity);
        UserAccountEntity newUserAccountEntity = new UserAccountEntity();
        newUserAccountEntity.setId(this.sequenceCreater.nextLongId());
        newUserAccountEntity.setUserId(newUser.getId());
        this.userAccountMapper.insert((Object)newUserAccountEntity);
        this.doInitComplete(newUser, newUserInformation, newUserLocationEntity);
    }

    @Override
    @Async
    public void initComplete(Long userId) {
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(userId);
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationByUserId(userId);
        UserLocationEntity userLocationEntity = this.userLocationService.getUserLocationByUserId(userId);
        this.doInitComplete(userInfoEntity, userInformationEntity, userLocationEntity);
    }

    private void doInitComplete(UserInfoEntity userInfo, UserInformationEntity userInformation, UserLocationEntity userLocation) {
        Long initUserInfoCompleteStatus = this.userPersonalInfoService.initUserInfoCompleteStatus(userInfo, userInformation, userLocation);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237id:{}, \u521d\u59cb\u5316\u8d44\u6599\u5b8c\u6210\u5ea6: {}", (Object)userInfo.getId(), (Object)initUserInfoCompleteStatus);
        }
        UserInformationEntity updateUserInformation = new UserInformationEntity();
        updateUserInformation.setInfoCompleteState(initUserInfoCompleteStatus);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInformationEntity::getUserId, (Object)userInfo.getId());
        this.userInformationMapper.update((Object)updateUserInformation, (Wrapper)queryWrapper);
    }

    public UserExtendServiceImpl(AliyunOSSService aliyunOSSService, UserProperties userProperties, CommonProperties commonProperties, AliyunOssProperties aliyunOssProperties, SequenceCreater sequenceCreater, UserInformationMapper userInformationMapper, UserStatisticsMapper userStatisticsMapper, UserLocationMapper userLocationMapper, UserAccountMapper userAccountMapper, LocationIntegrationService locationIntegrationService, UserPersonalInfoService userPersonalInfoService, UserInformationService userInformationService, UserLocationService userLocationService, UserInfoService userInfoService) {
        this.aliyunOSSService = aliyunOSSService;
        this.userProperties = userProperties;
        this.commonProperties = commonProperties;
        this.aliyunOssProperties = aliyunOssProperties;
        this.sequenceCreater = sequenceCreater;
        this.userInformationMapper = userInformationMapper;
        this.userStatisticsMapper = userStatisticsMapper;
        this.userLocationMapper = userLocationMapper;
        this.userAccountMapper = userAccountMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.userPersonalInfoService = userPersonalInfoService;
        this.userInformationService = userInformationService;
        this.userLocationService = userLocationService;
        this.userInfoService = userInfoService;
    }
}

