/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.constant.UserStateEnum;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.sync.HuolaUserRegisterIntegrationService;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.mapper.UserInfoMapper;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.canel.CancelUserParam;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.utils.FileMd5Util;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.sync.facade.param.UserRegisterParam;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserInfoServiceImpl
implements UserInfoService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoServiceImpl.class);
    @Resource
    private UserInfoMapper userInfoMapper;
    @Autowired
    private UserInfoCacheService userInfoCacheService;
    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;
    @Resource
    private HuolaUserRegisterIntegrationService userRegisterIntegrationService;
    @Autowired
    private CommonProperties commonProperties;
    @Autowired
    private UserProperties userProperties;

    @Override
    public Boolean cancelUser(CancelUserParam cancelUserParam) {
        return null;
    }

    @Override
    public Long generateUserId(UserRegisterParam userRegisterParam) {
        return this.userRegisterIntegrationService.userRegister(userRegisterParam);
    }

    @Override
    public void updateStatus(Long userId, UserStateEnum status) {
    }

    @Override
    public Optional<Long> userUnionIdExist(String unionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, (Object)unionId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, (Object)0);
        List userGrantWechatAppEntityList = this.userGrantWechatAppMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)userGrantWechatAppEntityList)) {
            return Optional.ofNullable(((UserGrantWechatAppEntity)userGrantWechatAppEntityList.get(0)).getUserId());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> userPhoneExist(String phone) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getPhone, (Object)phone);
        List userWechatAppEntityList = this.userInfoMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)userWechatAppEntityList)) {
            return Optional.of(((UserInfoEntity)userWechatAppEntityList.get(0)).getId());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> userUsernameExist(String username) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getUsername, (Object)username);
        List userInfoEntityList = this.userInfoMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)userInfoEntityList)) {
            return Optional.of(((UserInfoEntity)userInfoEntityList.get(0)).getId());
        }
        return Optional.empty();
    }

    @Override
    public boolean checkUserPassword(Long userId, String username, String password) {
        UserInfoEntity userInfoEntity = (UserInfoEntity)this.userInfoMapper.selectById((Serializable)userId);
        String targetPassword = MD5Util.encode((String)(MD5Util.encode((String)password) + userInfoEntity.getSalt()));
        String realPassword = userInfoEntity.getPassword();
        return Objects.equals(targetPassword, realPassword);
    }

    @Override
    public void updateUserPassword(Long userId, String password) {
        UserInfoEntity dbUserInfo = (UserInfoEntity)this.userInfoMapper.selectById((Serializable)userId);
        String salt = dbUserInfo.getSalt();
        UserInfoEntity userInfoEntity = new UserInfoEntity();
        userInfoEntity.setId(userId);
        userInfoEntity.setPassword(MD5Util.encode((String)(MD5Util.encode((String)password) + salt)));
        this.userInfoMapper.updateById((Object)userInfoEntity);
    }

    @Override
    public boolean hasSettingPassword(String username) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getUsername, (Object)username);
        List userInfoEntityList = this.userInfoMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)userInfoEntityList)) {
            return StringUtils.isNotBlank((CharSequence)((UserInfoEntity)userInfoEntityList.get(0)).getPassword());
        }
        log.error("\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff0c\u7528\u6237\u540d\uff1a{}", (Object)username);
        return false;
    }

    @Override
    public void bindPhone(Long userId, String phone) {
        UserInfoEntity userInfoEntity = new UserInfoEntity();
        userInfoEntity.setId(userId);
        userInfoEntity.setPhone(phone);
        this.userInfoMapper.updateById((Object)userInfoEntity);
    }

    @Override
    public void bindUsername(Long userId, String username) {
        UserInfoEntity userInfoEntity = new UserInfoEntity();
        userInfoEntity.setId(userId);
        userInfoEntity.setUsername(username);
        this.userInfoMapper.updateById((Object)userInfoEntity);
    }

    @Override
    public UserInfoEntity selectUserById(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getId, (Object)userId);
        queryWrapper.eq(UserInfoEntity::getDeleted, (Object)0);
        return (UserInfoEntity)this.userInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public UserInfoEntity selectAllUserById(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getId, (Object)userId);
        return (UserInfoEntity)this.userInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public int updateUserInfo(UserInfoEntity userInfoEntity) {
        return this.userInfoMapper.updateById((Object)userInfoEntity);
    }

    @Override
    public Boolean headImgRepair() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getDeleted, (Object)0);
        queryWrapper.eq(UserInfoEntity::getMigration, (Object)1);
        List userInfoEntities = this.userInfoMapper.selectList((Wrapper)queryWrapper);
        userInfoEntities.forEach(userInfoEntity -> {
            if (this.updateHeadImg(userInfoEntity.getHeadImg()).booleanValue()) {
                UserInfoEntity newUserInfo = new UserInfoEntity();
                newUserInfo.setId(userInfoEntity.getId());
                newUserInfo.setHeadImg(this.userProperties.getDefaultHeadImageUrl());
                this.userInfoMapper.updateById((Object)newUserInfo);
                this.userInfoCacheService.clearUserCache(userInfoEntity.getId());
            }
        });
        return Boolean.TRUE;
    }

    private Boolean updateHeadImg(String headImg) {
        try {
            URL url = new URL(headImg);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;
            if (conn.getResponseCode() == HttpStatus.OK.value()) {
                inputStream = conn.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(buf)) >= 0) {
                    baos.write(buf, 0, n);
                }
                byte[] content = baos.toByteArray();
                String md5 = FileMd5Util.getMd5(content);
                if (this.commonProperties.getEmptyHeadImgFileMd5().contains(md5)) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            log.error("\u68c0\u9a8c\u6587\u4ef6md5\u51fa\u9519", (Throwable)e);
        }
        return false;
    }
}

