/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.user.constant.BaseDistributeKeyConstant;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.constant.UserBizConfigProperties;
import com.bxm.egg.user.convert.EggSixParamConverter;
import com.bxm.egg.user.info.UserExtendService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.info.msg.UserInfoChangeSender;
import com.bxm.egg.user.integration.EggSixEnjoyIntegrationService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.integration.SixEnjoyUserIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserAccountIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.model.bo.UserWechatBindBO;
import com.bxm.egg.user.model.dto.info.UserBindWxDTO;
import com.bxm.egg.user.model.entity.TempInviteBindEntity;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.UserBindWxParam;
import com.bxm.egg.user.properties.SixEnjoyUrlProperties;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.sync.facade.dto.UserRewardDTO;
import com.bxm.sync.facade.param.UpdateUserRewardParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserWechatGrantServiceImpl
implements UserWechatGrantService {
    private static final Logger log = LoggerFactory.getLogger(UserWechatGrantServiceImpl.class);
    @Autowired
    private UserGrantWechatAppMapper userGrantWechatAppMapper;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private UserInfoChangeSender userInfoChangeSender;
    @Autowired
    private UserExtendService userExtendService;
    @Autowired
    private EggSixEnjoyIntegrationService eggSixEnjoyIntegrationService;
    @Autowired
    private SixEnjoyUserAccountIntegrationService enjoyUserAccountIntegrationService;
    @Autowired
    private SixEnjoyUserIntegrationService enjoyUserIntegrationService;
    @Autowired
    private UserEggInviteService userEggInviteService;
    @Autowired
    private UserBizConfigProperties userBizConfigProperties;
    @Autowired
    private MessageFacadeIntegrationService messageFacadeIntegrationService;
    @Autowired
    private SixEnjoyUrlProperties sixEnjoyUrlProperties;
    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    public Optional<UserGrantWechatAppEntity> userInfoUnionIdExist(String unionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, (Object)unionId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, (Object)0);
        UserGrantWechatAppEntity userGrantWechatAppEntity = (UserGrantWechatAppEntity)this.userGrantWechatAppMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.nonNull(userGrantWechatAppEntity)) {
            return Optional.of(userGrantWechatAppEntity);
        }
        return Optional.empty();
    }

    @Override
    public int updateWechatGrantBindUserId(Long userId, String unionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, (Object)unionId);
        UserGrantWechatAppEntity updateEntity = new UserGrantWechatAppEntity();
        updateEntity.setUserId(userId);
        return this.userGrantWechatAppMapper.update((Object)updateEntity, (Wrapper)queryWrapper);
    }

    @Override
    public Message userBindWx(UserBindWxParam userBindWxParam) {
        String resource = this.buildBindWxUserLockKey(userBindWxParam.getUserId());
        if (!this.distributedLock.lock(resource)) {
            log.info("\u51fa\u73b0\u91cd\u590d\u70b9\u51fb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)userBindWxParam));
            return null;
        }
        if (this.userHasBindWx(userBindWxParam.getUserId()).booleanValue()) {
            this.distributedLock.unlock(resource);
            return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u5fae\u4fe1\uff0c\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a");
        }
        if (this.userInfoUnionIdExist(userBindWxParam.getUnionId()).isPresent()) {
            this.updateWechatGrantBindUserId(userBindWxParam.getUserId(), userBindWxParam.getUnionId());
        } else {
            UserWechatBindBO userWechatBindBO = new UserWechatBindBO();
            BeanUtils.copyProperties((Object)userBindWxParam, (Object)userWechatBindBO);
            this.grantBindWxRecord(userWechatBindBO);
        }
        this.updateUserWxBindRelationInfo(userBindWxParam);
        this.userInfoChangeSender.sendUserChangeMsg(userBindWxParam.getUserId());
        this.userExtendService.initComplete(userBindWxParam.getUserId());
        if (StringUtils.isGrateOrEqualThan((String)userBindWxParam.getCurVer(), (String)"2.0.1")) {
            this.userBindWxHandler(userBindWxParam);
        } else {
            this.eggSixEnjoyIntegrationService.bind(EggSixParamConverter.convert((UserBindWxParam)userBindWxParam));
        }
        this.distributedLock.unlock(resource);
        return Message.build((boolean)true);
    }

    @Override
    public void userBindWxHandler(UserBindWxParam userBindWxParam) {
        UserRewardDTO userRewardInfo = this.enjoyUserIntegrationService.getUserRewardInfo(userBindWxParam.getUserId(), userBindWxParam.getDevcId());
        if (userRewardInfo == null) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u9a8c\u7528\u6237\u5728\u516d\u4eab\u662f\u5426\u5b58\u5728\uff1a{}", (Object)userBindWxParam.getUserId());
            return;
        }
        KeyGenerator keyGenerator = this.userBindRewardKey(userBindWxParam.getUserId());
        Boolean exists = this.redisSetAdapter.exists(keyGenerator, (Object)userBindWxParam.getUserId());
        if (exists.booleanValue()) {
            log.debug("\u7528\u6237\u5df2\u53d1\u653e\u8fc7\u5956\u52b1\uff1a{}", (Object)userBindWxParam.getUserId());
            return;
        }
        int sendInviteUserReward = this.sendUserReward(userRewardInfo, userBindWxParam);
        if (Objects.nonNull(userRewardInfo.getInviteUserId())) {
            this.sendInviteUserReward(userRewardInfo.getInviteUserId(), userBindWxParam.getNickName(), sendInviteUserReward);
        } else {
            this.newSendInviteUserReward(userBindWxParam);
        }
        this.redisSetAdapter.add(keyGenerator, new Object[]{userBindWxParam.getUserId()});
    }

    private KeyGenerator userBindRewardKey(Long userId) {
        return RedisConfig.USER_BIND_WX_REWARD.copy().appendKey((Object)(userId % 100L));
    }

    private void newSendInviteUserReward(UserBindWxParam userBindWxParam) {
        TempInviteBindEntity userTempBindInvite = this.userEggInviteService.getUserTempBindInvite(userBindWxParam.getUnionId());
        if (Objects.isNull(userTempBindInvite)) {
            return;
        }
        UserInfoEntity userInfoEntity = this.userInfoService.selectAllUserById(userBindWxParam.getUserId());
        if (userInfoEntity.getCreateTime().getTime() < userTempBindInvite.getCreateTime().getTime()) {
            this.userEggInviteService.delInviteBindByUnionId(userBindWxParam.getUnionId());
            return;
        }
        Long inviteUserId = userTempBindInvite.getUserId();
        Boolean updateUserInvite = this.enjoyUserIntegrationService.updateUserInvite(userBindWxParam.getUserId(), inviteUserId);
        if (!updateUserInvite.booleanValue()) {
            log.error("\u7ed9\u516d\u4eab\u7ed1\u5b9a\u9080\u8bf7\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5dubbo\u95ee\u9898\u8fd8\u662f\u7528\u6237\u5df2\u6709\u7ed1\u5b9a\u4eba\uff1auserId:{},inviteUserId:{}", (Object)userBindWxParam.getUserId(), (Object)inviteUserId);
            return;
        }
        this.sendInviteUserReward(inviteUserId, userBindWxParam.getNickName(), this.userBizConfigProperties.getNewInviteReward());
        this.userEggInviteService.delInviteBindByUnionId(userBindWxParam.getUnionId());
    }

    private void sendInviteUserReward(Long inviteUserId, String beInviteUserName, int sendInviteUserReward) {
        if (sendInviteUserReward > 0) {
            this.enjoyUserAccountIntegrationService.addFoodsNum(inviteUserId, Integer.valueOf(sendInviteUserReward), "\u9080\u8bf7\u65b0\u7528\u6237\u6ce8\u518c\u5956\u52b1");
            PushMessage message = PushMessage.build((String)"\u9080\u8bf7\u597d\u53cb\u5956\u52b1\u5df2\u9001\u8fbe", (String)("\u60a8\u9080\u8bf7\u7684\u597d\u53cb[" + beInviteUserName + "]\u5df2\u6ce8\u518c\u5e76\u7ed1\u5b9a\u5fae\u4fe1\uff0c\u5956\u52b1\u60a8" + sendInviteUserReward + "g\u7cae\u98df\uff0c\u591a\u9080\u591a\u5f97\u54e6~"));
            message.assign(inviteUserId);
            message.getPayloadInfo().setProtocol(ProtocolFactory.appH5().url(this.sixEnjoyUrlProperties.getInvitePage()).build());
            this.messageFacadeIntegrationService.sendPushMessage(message);
        }
    }

    private int sendUserReward(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam) {
        int sendInviteUserReward = 0;
        UpdateUserRewardParam updateUserRewardParam = new UpdateUserRewardParam();
        if (!userRewardInfo.getRegisterReward().booleanValue()) {
            this.enjoyUserAccountIntegrationService.addFoodsNum(userBindWxParam.getUserId(), this.userBizConfigProperties.getRegisterReward(), "\u65b0\u7528\u6237\u6ce8\u518c\u5956\u52b1");
            sendInviteUserReward += this.userBizConfigProperties.getInviteReward().intValue();
            updateUserRewardParam.setRegisterReward(Boolean.valueOf(true));
            updateUserRewardParam.setDevcId(userBindWxParam.getDevcId());
        }
        if (!userRewardInfo.getWxReward().booleanValue()) {
            this.enjoyUserAccountIntegrationService.addFoodsNum(userBindWxParam.getUserId(), this.userBizConfigProperties.getWxBindReward(), "\u65b0\u7528\u6237\u5fae\u4fe1\u7ed1\u5b9a\u5956\u52b1");
            sendInviteUserReward += this.userBizConfigProperties.getInviteReward().intValue();
            updateUserRewardParam.setWxReward(Boolean.valueOf(true));
        }
        updateUserRewardParam.setUserId(userBindWxParam.getUserId());
        updateUserRewardParam.setNickname(userBindWxParam.getNickName());
        updateUserRewardParam.setHeadImg(userBindWxParam.getHeadImageUrl());
        this.enjoyUserIntegrationService.updateUserReward(updateUserRewardParam);
        return sendInviteUserReward;
    }

    private void updateUserWxBindRelationInfo(UserBindWxParam userBindWxParam) {
        UserInfoEntity updateUserInfo = new UserInfoEntity();
        String newHeadImg = this.userExtendService.uploadWechatImage(userBindWxParam.getHeadImageUrl(), (BasicParam)userBindWxParam, userBindWxParam.getUserId());
        userBindWxParam.setHeadImageUrl(newHeadImg);
        updateUserInfo.setId(userBindWxParam.getUserId());
        updateUserInfo.setHeadImg(newHeadImg);
        updateUserInfo.setNickname(userBindWxParam.getNickName());
        updateUserInfo.setSex(userBindWxParam.getSex());
        this.userInfoService.updateUserInfo(updateUserInfo);
    }

    @Override
    public Boolean userHasBindWx(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUserId, (Object)userId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, (Object)0);
        List grantWechatAppEntityList = this.userGrantWechatAppMapper.selectList((Wrapper)queryWrapper);
        return !CollectionUtils.isEmpty((Collection)grantWechatAppEntityList);
    }

    @Override
    public Boolean grantBindWxRecord(UserWechatBindBO userWechatBindBO) {
        UserGrantWechatAppEntity entity = new UserGrantWechatAppEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setCountry(userWechatBindBO.getCountry());
        entity.setProvince(userWechatBindBO.getProvince());
        entity.setCity(userWechatBindBO.getCity());
        entity.setNickName(userWechatBindBO.getNickName());
        entity.setHeadImg(userWechatBindBO.getHeadImageUrl());
        entity.setOpenId(userWechatBindBO.getOpenId());
        entity.setUnionId(userWechatBindBO.getUnionId());
        entity.setSex(userWechatBindBO.getSex());
        entity.setUserId(userWechatBindBO.getUserId());
        entity.setCreateTime(new Date());
        return this.userGrantWechatAppMapper.insert((Object)entity) > 0;
    }

    private String buildBindWxUserLockKey(Long userId) {
        return BaseDistributeKeyConstant.USER_BIND_WX_LOCK_KEY.copy().appendKey((Object)userId).gen();
    }

    @Override
    public UserBindWxDTO getUserHasBindWx(Long userId, Long devcId) {
        UserRewardDTO userRewardInfo = this.enjoyUserIntegrationService.getUserRewardInfo(userId, devcId);
        Boolean userHasBindWx = this.userHasBindWx(userId);
        if (userHasBindWx.booleanValue()) {
            return UserBindWxDTO.builder().isBind(userHasBindWx).build();
        }
        return UserBindWxDTO.builder().foodsNum(userRewardInfo != null && userRewardInfo.getRegisterReward() != false ? this.userBizConfigProperties.getWxBindReward() : this.userBizConfigProperties.getRegisterWxAndReward()).isBind(Boolean.valueOf(false)).build();
    }
}

