/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.event.UserInfoChangeEvent;
import com.bxm.egg.user.info.event.UserNickNameAndHeadImgChangeEvent;
import com.bxm.egg.user.integration.IMIntegrationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UserInfoChangeListener {
    private static final Logger log = LoggerFactory.getLogger(UserInfoChangeListener.class);
    private UserInfoCacheService userInfoCacheService;
    private IMIntegrationService imIntegrationService;

    @EventListener
    @Async
    public void userInfoChangeEvent(UserInfoChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("\u76d1\u542c\u5230\u7528\u6237\u4fe1\u606f\u6539\u53d8\u4e8b\u4ef6\uff0c\u4e8b\u4ef6\u5185\u5bb9: {}", (Object)JSON.toJSONString((Object)event));
        }
        this.userInfoCacheService.clearUserCache(event.getUserId());
    }

    @EventListener
    @Async
    public void changeNickNameAndHeadImg(UserNickNameAndHeadImgChangeEvent event) {
        this.imIntegrationService.syncUser(event.getUserId(), event.getNickName(), event.getHeadImg());
    }

    public UserInfoChangeListener(UserInfoCacheService userInfoCacheService, IMIntegrationService imIntegrationService) {
        this.userInfoCacheService = userInfoCacheService;
        this.imIntegrationService = imIntegrationService;
    }
}

