/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite.egg.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.dto.SixEnjoyReceiveFoodsDTO;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.integration.sync.SixEnjoyDataStatisticsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyFriendsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyInviteFoodsIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.EggInviteMapper;
import com.bxm.egg.user.mapper.TempInviteBindMapper;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.invite.RollBarrageDTO;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import com.bxm.egg.user.model.entity.TempInviteBindEntity;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.param.invite.InviteBindParam;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.egg.user.properties.SixEnjoyUrlProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.sync.facade.dto.UserTodayContributionDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserEggInviteServiceImpl
implements UserEggInviteService {
    private static final Logger log = LoggerFactory.getLogger(UserEggInviteServiceImpl.class);
    @Autowired
    private EggInviteMapper eggInviteMapper;
    @Autowired
    private UserProperties userProperties;
    @Autowired
    private TempInviteBindMapper tempInviteBindMapper;
    @Autowired
    private SixEnjoyUrlProperties sixEnjoyUrlProperties;
    @Autowired
    private SixEnjoyInviteFoodsIntegrationService inviteFoodsIntegrationService;
    @Autowired
    private SixEnjoyDataStatisticsIntegrationService statisticsIntegrationService;
    @Autowired
    private UserInfoCacheService userInfoCacheService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private UserWechatGrantService userWechatGrantService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private SixEnjoyFriendsIntegrationService sixEnjoyFriendsIntegrationService;

    @Override
    public IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam) {
        Page page = new Page((long)invitePageParam.getPageNum().intValue(), (long)invitePageParam.getPageSize().intValue());
        page.setSearchCount(false);
        if (null == invitePageParam.getUserId()) {
            return PlusPageModelDTO.build(null);
        }
        IPage result = this.eggInviteMapper.queryInviteByPage(page, invitePageParam.getUserId());
        List userIdList = result.getRecords().stream().map(InviteUserListDTO::getUserId).collect(Collectors.toList());
        List userFoodsList = this.inviteFoodsIntegrationService.getTodayContribution(userIdList);
        result.getRecords().forEach(inviteUser -> {
            Optional<UserTodayContributionDTO> userFoodValue;
            UserCacheInfoBO cacheInfoBO = this.userInfoCacheService.load(inviteUser.getUserId());
            inviteUser.setHeadImg(cacheInfoBO.getHeadImg());
            inviteUser.setNickName(cacheInfoBO.getNickname());
            if (null == inviteUser.getHasEggNum()) {
                inviteUser.setHasEggNum(Integer.valueOf(0));
            }
            if ((userFoodValue = userFoodsList.stream().filter(userFood -> Objects.equals(inviteUser.getUserId(), userFood.getUserId())).findFirst()).isPresent()) {
                inviteUser.setContributeFoodsNum(userFoodValue.get().getFoodNum());
                inviteUser.setContributeAllFoodsNum(userFoodValue.get().getAllFoodNum());
            } else {
                inviteUser.setContributeFoodsNum(Integer.valueOf(0));
                inviteUser.setContributeAllFoodsNum(Integer.valueOf(0));
            }
        });
        List collect = result.getRecords().stream().sorted(Comparator.comparing(InviteUserListDTO::getContributeFoodsNum).reversed()).collect(Collectors.toList());
        result.setRecords(collect);
        PlusPageModelDTO pageModelDTO = PlusPageModelDTO.build((IPage)result);
        if (result.getRecords().size() == invitePageParam.getPageSize().intValue()) {
            pageModelDTO.setHasNextPage(true);
            pageModelDTO.setLastPage(false);
        } else {
            pageModelDTO.setHasNextPage(false);
            pageModelDTO.setLastPage(true);
        }
        return pageModelDTO;
    }

    @Override
    public Long getInviteUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EggInviteEntity::getBeInviteUserId, (Object)userId);
        EggInviteEntity eggInviteEntity = (EggInviteEntity)this.eggInviteMapper.selectOne((Wrapper)queryWrapper);
        if (eggInviteEntity != null) {
            return eggInviteEntity.getUserId();
        }
        return null;
    }

    @Override
    public int countInviteUser(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EggInviteEntity::getUserId, (Object)userId);
        return this.eggInviteMapper.selectCount((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getUserInviteHeadImgList(Long userId) {
        return this.eggInviteMapper.getInviteUserHeadImg(userId, this.userProperties.getInviteHeadImgNum().intValue());
    }

    @Override
    public List<RollBarrageDTO> getRollBarrage() {
        List rollBarrageDTOS = (List)this.redisStringAdapter.get(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy(), (TypeReference)new TypeReference<List<RollBarrageDTO>>(){});
        if (rollBarrageDTOS != null && rollBarrageDTOS.size() > 0) {
            return rollBarrageDTOS;
        }
        List userUseEggNumMaxList = this.statisticsIntegrationService.getUserUseEggNumMaxList();
        List<RollBarrageDTO> rollBarrageDTOList = userUseEggNumMaxList.stream().map(userUseEggNumDTO -> {
            UserCacheInfoBO cacheInfoBO = this.userInfoCacheService.load(userUseEggNumDTO.getUserId());
            String nickname = cacheInfoBO.getNickname();
            return RollBarrageDTO.builder().eggNums(userUseEggNumDTO.getUseEggNum()).nickname(StringUtils.hideRealName((String)nickname)).build();
        }).collect(Collectors.toList());
        this.redisStringAdapter.set(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy(), rollBarrageDTOList);
        this.redisStringAdapter.expire(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy(), (long)DateUtils.getCurSeconds());
        return rollBarrageDTOList;
    }

    @Override
    public Boolean tempBindInvite(InviteBindParam inviteBindParam) {
        boolean lock = this.distributedLock.lock(inviteBindParam.getUnionId() + inviteBindParam.getUserId());
        if (!lock) {
            log.info("\u51fa\u73b0\u91cd\u590d\u70b9\u51fb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inviteBindParam));
            return Boolean.FALSE;
        }
        Optional<UserGrantWechatAppEntity> userGrantWechatAppEntity = this.userWechatGrantService.userInfoUnionIdExist(inviteBindParam.getUnionId());
        if (userGrantWechatAppEntity.isPresent()) {
            this.sixEnjoyFriendsIntegrationService.insertFriendsToSixEnjoy(inviteBindParam.getUserId(), userGrantWechatAppEntity.get().getUserId());
        } else {
            this.delInviteBindByUnionId(inviteBindParam.getUnionId());
            TempInviteBindEntity tempInviteBindEntity = new TempInviteBindEntity();
            tempInviteBindEntity.setId(this.sequenceCreater.nextLongId());
            tempInviteBindEntity.setUnionId(inviteBindParam.getUnionId());
            tempInviteBindEntity.setUserId(inviteBindParam.getUserId());
            tempInviteBindEntity.setSource(inviteBindParam.getSource());
            tempInviteBindEntity.setCreateTime(new Date());
            this.tempInviteBindMapper.insert((Object)tempInviteBindEntity);
        }
        this.distributedLock.unlock(inviteBindParam.getUnionId() + inviteBindParam.getUserId());
        return Boolean.TRUE;
    }

    @Override
    public TempInviteBindEntity getUserTempBindInvite(String unionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TempInviteBindEntity::getUnionId, (Object)unionId);
        return (TempInviteBindEntity)this.tempInviteBindMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public void delInviteBindByUnionId(String unionId) {
        this.tempInviteBindMapper.delInviteBindByUnionId(unionId);
    }

    @Override
    public void delInviteBindByDate(Date date) {
        this.tempInviteBindMapper.delInviteBindByDate(date);
    }

    @Override
    public Integer getReceiveContributeFoods(Long userId) {
        UserCacheInfoBO load = this.userInfoCacheService.load(userId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("bxm_mobile", load.getPhone());
        SixEnjoyReceiveFoodsDTO request = this.request(param, this.sixEnjoyUrlProperties.getCanReceiveFoodsUrl());
        return request != null && request.getCode() == 1 ? request.getData() : 0;
    }

    @Override
    public Boolean receiveFoods(Long userId) {
        UserCacheInfoBO load = this.userInfoCacheService.load(userId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("bxm_mobile", load.getPhone());
        SixEnjoyReceiveFoodsDTO request = this.request(param, this.sixEnjoyUrlProperties.getReceiveFoodsUrl());
        return request != null && request.getCode() == 1;
    }

    private SixEnjoyReceiveFoodsDTO request(Map<String, String> param, String url) {
        String response = OkHttpUtils.postJsonBody((String)url, (String)JSON.toJSONString(param), null);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u86cb\u86cb\u4f73,\u8bf7\u6c42\u6570\u636e\uff1a{},\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(param), (Object)response);
        }
        return (SixEnjoyReceiveFoodsDTO)JSON.parseObject((String)response, SixEnjoyReceiveFoodsDTO.class);
    }

    public static void main(String[] args) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("bxm_mobile", "18363370745");
        String response = OkHttpUtils.postJsonBody((String)"https://bxm.liuxiang.city/api/yangjixiadan/Xiaochengxu/yaoqing_lingqu_bxm", (String)JSON.toJSONString(param), null);
        SixEnjoyReceiveFoodsDTO sixEnjoyReceiveFoodsDTO = (SixEnjoyReceiveFoodsDTO)JSON.parseObject((String)response, SixEnjoyReceiveFoodsDTO.class);
        System.out.println("response = " + sixEnjoyReceiveFoodsDTO);
    }
}

