/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite.impl;

import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.invite.InviteProcessService;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.invite.InviteRecordService;
import com.bxm.egg.user.invite.InviteTypeProcessorManager;
import com.bxm.egg.user.invite.UserInviteService;
import com.bxm.egg.user.invite.bind.BindInviteManager;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.model.param.InviteProcessParam;
import com.bxm.egg.user.model.vo.InviteRecord;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class InviteProcessServiceImpl
implements InviteProcessService {
    private static final Logger log = LoggerFactory.getLogger(InviteProcessServiceImpl.class);
    private final InviteTypeProcessorManager inviteTypeProcessorManager;
    private final InviteRecordService inviteRecordService;
    private UserInviteService userInviteService;
    private final BindInviteManager bindInviteManager;
    private final UserInfoCacheService userInfoCacheService;

    @Autowired
    public InviteProcessServiceImpl(InviteTypeProcessorManager inviteTypeProcessorManager, InviteRecordService inviteRecordService, BindInviteManager bindInviteManager, UserInfoCacheService userInfoCacheService) {
        this.inviteTypeProcessorManager = inviteTypeProcessorManager;
        this.inviteRecordService = inviteRecordService;
        this.bindInviteManager = bindInviteManager;
        this.userInfoCacheService = userInfoCacheService;
    }

    private UserInviteService getUserInviteService() {
        if (this.userInviteService == null) {
            this.userInviteService = (UserInviteService)SpringContextHolder.getBean(UserInviteService.class);
        }
        return this.userInviteService;
    }

    @Override
    @Async
    public void execAsyncActiveInvite(InviteProcessParam param) {
        log.debug("\u5904\u7406\u7528\u6237\u5efa\u7acb\u7684\u9080\u8bf7\u5173\u7cfb:{}", (Object)param);
        InviteRecord inviteRecord = this.inviteRecordService.getInviteRecordByInvitedUser(param.getInviteUserId(), param.getUserId());
        if (null != inviteRecord) {
            InviteProcessorContext context = new InviteProcessorContext();
            context.setRecord(inviteRecord);
            context.setBasicParam(param.getBasicParam());
            context.setInvitedEquipment(param.getEquipmentNum());
            context.setEffective(param.isEffective());
            context.setLoginIp(param.getLoginIp());
            Message message = this.inviteTypeProcessorManager.obtain(inviteRecord.getType()).afterInvited(context);
            if (!message.isSuccess()) {
                log.warn("\u5efa\u7acb\u9080\u8bf7\u5173\u7cfb\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)param, (Object)message);
                return;
            }
        }
        this.bindUserInvite(param.getUserId());
        log.debug("\u7528\u6237\u5efa\u7acb\u9080\u8bf7\u5173\u7cfb\u5b8c\u6210\uff1a{}", (Object)param);
    }

    private void bindUserInvite(Long userId) {
        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
        userInviteBindDTO.setUserId(userId);
        userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.LOGIN_APP);
        this.bindInviteManager.bindInvite(userInviteBindDTO);
        this.getUserInviteService().changeHistoryStatus(userId, (byte)1);
    }

    @Override
    public String getFinalInviteTitle(UserInviteHistoryBean history) {
        return this.inviteTypeProcessorManager.obtain(history.getType()).decorateTitle(history);
    }

    @Override
    public String getLevelTwoFinalInviteTitle(Long userId, UserInviteHistoryBean history) {
        if (!Objects.equals(userId, history.getInviteUserId())) {
            return "\u6765\u81ea" + this.userInfoCacheService.load(history.getInviteUserId()).getNickname() + this.getFinalInviteTitle(history);
        }
        return "\u6765\u81ea\u4f60" + this.getFinalInviteTitle(history);
    }
}

