/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.location.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.mapper.UserLocationMapper;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.param.UserHomeTownParam;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserLocationServiceImpl
implements UserLocationService {
    private static final Logger log = LoggerFactory.getLogger(UserLocationServiceImpl.class);
    private final UserLocationMapper userLocationMapper;

    @Override
    public UserLocationEntity getUserLocationByUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserLocationEntity::getUserId, (Object)userId);
        UserLocationEntity userLocationEntity = (UserLocationEntity)this.userLocationMapper.selectOne((Wrapper)queryWrapper);
        if (userLocationEntity == null) {
            return this.buildValidUserLocation(userId);
        }
        return userLocationEntity;
    }

    private UserLocationEntity buildValidUserLocation(Long userId) {
        UserLocationEntity userLocationEntity = new UserLocationEntity();
        userLocationEntity.setId(Long.valueOf(0L));
        userLocationEntity.setUserId(userId);
        userLocationEntity.setCreateTime(LocalDateTime.now());
        userLocationEntity.setModifyTime(LocalDateTime.now());
        return userLocationEntity;
    }

    @Override
    public int updateUserHometownInfo(UserHomeTownParam userHomeTownParam) {
        UserLocationEntity userLocationEntity = new UserLocationEntity();
        userLocationEntity.setHometownCode(userHomeTownParam.getHometownCode());
        userLocationEntity.setHometownName(userHomeTownParam.getHometownName());
        LambdaQueryWrapper updateQueryWrapper = new LambdaQueryWrapper();
        updateQueryWrapper.eq(UserLocationEntity::getUserId, (Object)userHomeTownParam.getUserId());
        return this.userLocationMapper.update((Object)userLocationEntity, (Wrapper)updateQueryWrapper);
    }

    @Override
    public int updateUserLocationInfo(Long userId, String locationCode, String locationName) {
        UserLocationEntity userLocationEntity = new UserLocationEntity();
        userLocationEntity.setLocationCode(locationCode);
        userLocationEntity.setLocationName(locationName);
        userLocationEntity.setUserId(userId);
        LambdaQueryWrapper updateQueryWrapper = new LambdaQueryWrapper();
        updateQueryWrapper.eq(UserLocationEntity::getUserId, (Object)userId);
        return this.userLocationMapper.update((Object)userLocationEntity, (Wrapper)updateQueryWrapper);
    }

    @Override
    public int updateUserLocationInfo(Long userId, UserLocationEntity userLocationEntity) {
        LambdaQueryWrapper updateQueryWrapper = new LambdaQueryWrapper();
        updateQueryWrapper.eq(UserLocationEntity::getUserId, (Object)userId);
        return this.userLocationMapper.update((Object)userLocationEntity, (Wrapper)updateQueryWrapper);
    }

    public UserLocationServiceImpl(UserLocationMapper userLocationMapper) {
        this.userLocationMapper = userLocationMapper;
    }
}

