/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.facade.param.UserWarmActionParam;
import com.bxm.egg.user.login.UserLogService;
import com.bxm.egg.user.login.event.LoginEvent;
import com.bxm.egg.user.model.param.login.LoginParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.warmlevel.impl.WarmHandlerProxy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class LoginListener {
    private static final Logger log = LoggerFactory.getLogger(LoginListener.class);
    @Resource
    private UserLogService userLogService;
    @Resource
    private WarmHandlerProxy warmHandlerProxy;
    @Resource
    private UserProperties userProperties;

    @EventListener
    @Async
    public void userLoginEvent(LoginEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("\u76d1\u542c\u5230\u7528\u6237\u767b\u5f55\u4e8b\u4ef6\uff0c\u4e8b\u4ef6\u5185\u5bb9: {}", (Object)JSON.toJSONString((Object)event));
        }
        this.userLogService.recordLoginLog((LoginParam)event.getLoginParam(), event.getLoginResult(), event.getLoginType());
        UserWarmActionParam userWarmActionParam = UserWarmActionParam.builder().userId(event.getUserId()).warmRuleEnum(WarmRuleEnum.LOGIN).warmValue(this.userProperties.getLoginWarmValue()).build();
        this.warmHandlerProxy.handle(userWarmActionParam);
    }
}

