/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy.support;

import com.bxm.egg.mq.common.constant.SmsTemplateEnum;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.convert.EggSixParamConverter;
import com.bxm.egg.user.info.UserExtendService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.integration.EggSixEnjoyIntegrationService;
import com.bxm.egg.user.integration.SmsIntegrationService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.UserBindWxParam;
import com.bxm.egg.user.model.param.login.WechatBindMobileLoginParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WechatBindMobileLoginStrategy
extends AbstractUserLoginStrategy<WechatBindMobileLoginParam> {
    private static final Logger log = LoggerFactory.getLogger(WechatBindMobileLoginStrategy.class);
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private SmsIntegrationService smsIntegrationService;
    @Resource
    private UserExtendService userExtendService;
    @Resource
    private UserWechatGrantService userWechatGrantService;
    @Resource
    private EggSixEnjoyIntegrationService eggSixEnjoyIntegrationService;

    @Override
    protected Message beforeLoginAuthentication(WechatBindMobileLoginParam loginParam) {
        if (!this.smsIntegrationService.verifyByType(SmsTemplateEnum.BINDING_PHONE, loginParam.getPhone(), loginParam.getSmsCode()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        Optional<UserGrantWechatAppEntity> userUnionIdExist = this.userWechatGrantService.userInfoUnionIdExist(loginParam.getUnionId());
        if (!userUnionIdExist.isPresent()) {
            return Message.build((boolean)false, (String)"\u5fae\u4fe1\u7528\u6237\u672a\u6388\u6743");
        }
        return Message.build((boolean)true);
    }

    @Override
    protected Long checkExists(WechatBindMobileLoginParam loginParam) {
        Optional<Long> userPhoneExist = this.userInfoService.userPhoneExist(loginParam.getPhone());
        if (!userPhoneExist.isPresent()) {
            return null;
        }
        loginParam.setUserId(userPhoneExist.get());
        return userPhoneExist.get();
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.WECHAT_BIND_MOBILE_LOGIN;
    }

    @Override
    protected boolean saveIdentity(WechatBindMobileLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(WechatBindMobileLoginParam loginParam, UserInfoEntity newUser) {
        String newHeadImg = this.userExtendService.uploadWechatImage(loginParam.getHeadImageUrl(), (BasicParam)loginParam, newUser.getId());
        newUser.setHeadImg(newHeadImg);
        newUser.setNickname(loginParam.getNickName());
        newUser.setSex(loginParam.getSex());
    }

    @Override
    protected void afterLogin(LoginResultDTO resultDTO, WechatBindMobileLoginParam loginParam) {
        this.userInfoService.bindPhone(resultDTO.getUserId(), loginParam.getPhone());
        this.userInfoService.bindUsername(resultDTO.getUserId(), loginParam.getPhone());
        this.userWechatGrantService.updateWechatGrantBindUserId(resultDTO.getUserId(), loginParam.getUnionId());
        this.userExtendService.initComplete(resultDTO.getUserId());
        if (StringUtils.isGrateOrEqualThan((String)loginParam.getCurVer(), (String)"2.0.1")) {
            UserBindWxParam userBindWxParam = new UserBindWxParam();
            userBindWxParam.setUserId(resultDTO.getUserId());
            userBindWxParam.setOpenId(loginParam.getOpenId());
            userBindWxParam.setUnionId(loginParam.getUnionId());
            userBindWxParam.setNickName(loginParam.getNickName());
            userBindWxParam.setDevcId(loginParam.getDevcId());
            this.userWechatGrantService.userBindWxHandler(userBindWxParam);
        } else {
            this.eggSixEnjoyIntegrationService.bind(EggSixParamConverter.convert((WechatBindMobileLoginParam)loginParam, (Long)resultDTO.getUserId()));
        }
    }

    @Override
    protected void updateExistUserInfo(Long userId, WechatBindMobileLoginParam loginParam) {
        UserInfoEntity updateUserInfo = new UserInfoEntity();
        String newHeadImg = this.userExtendService.uploadWechatImage(loginParam.getHeadImageUrl(), (BasicParam)loginParam, userId);
        updateUserInfo.setEquipmentId(loginParam.getDevcId());
        updateUserInfo.setId(userId);
        updateUserInfo.setHeadImg(newHeadImg);
        updateUserInfo.setNickname(loginParam.getNickName());
        updateUserInfo.setSex(loginParam.getSex());
        this.userInfoService.updateUserInfo(updateUserInfo);
    }
}

