/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.cache;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.facade.dto.UserGrantMedalDTO;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserMedalPopCacheManager {
    private static final Logger log = LoggerFactory.getLogger(UserMedalPopCacheManager.class);
    private RedisListAdapter redisListAdapter;
    private UserProperties userProperties;

    public void addUserMedalPopCache(Long userId, UserGrantMedalDTO userGrantMedalDTO) {
        KeyGenerator key = this.buildUserMedalPopKey(userId);
        userGrantMedalDTO.setV(UserGrantMedalDTO.CACHE_VERSION);
        this.redisListAdapter.leftPush(key, new Object[]{userGrantMedalDTO});
        this.redisListAdapter.expire(key, this.userProperties.getUserMedalPopExpiredSecond().longValue());
    }

    public UserGrantMedalDTO getUserMedalPopCache(Long userId) {
        KeyGenerator key = this.buildUserMedalPopKey(userId);
        Long size = this.redisListAdapter.size(key);
        if (size == 0L) {
            return null;
        }
        int i = 0;
        while ((long)i < size) {
            UserGrantMedalDTO userGrantMedalDTO = (UserGrantMedalDTO)this.redisListAdapter.rightPop(key, UserGrantMedalDTO.class);
            if (userGrantMedalDTO == null) {
                return null;
            }
            if (Objects.nonNull(userGrantMedalDTO.getV()) && userGrantMedalDTO.getV() >= UserGrantMedalDTO.CACHE_VERSION) {
                return userGrantMedalDTO;
            }
            ++i;
        }
        return null;
    }

    private KeyGenerator buildUserMedalPopKey(Long userId) {
        return RedisConfig.USER_POP_MEDAL_DATA.copy().appendKey((Object)userId);
    }

    public UserMedalPopCacheManager(RedisListAdapter redisListAdapter, UserProperties userProperties) {
        this.redisListAdapter = redisListAdapter;
        this.userProperties = userProperties;
    }
}

