/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.timer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.common.enums.AuthCodeEnum;
import com.bxm.egg.user.auth.UserAuthCodeService;
import com.bxm.egg.user.auth.UserBlockExpiredTaskService;
import com.bxm.egg.user.model.entity.UserBlockExpiredTaskEntity;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UserBlockExpiredTimeTask
extends AbstractCronXxlJob {
    private static final Logger log = LoggerFactory.getLogger(UserBlockExpiredTimeTask.class);
    @Resource
    private UserBlockExpiredTaskService userBlockExpiredTaskService;
    @Resource
    private UserAuthCodeService userAuthCodeService;

    public String cron() {
        return "0 0/1 * * * ?";
    }

    protected void executeLogic() {
        List<UserBlockExpiredTaskEntity> expiredTaskList = this.userBlockExpiredTaskService.getExpiredTaskList();
        if (log.isDebugEnabled()) {
            log.debug("\u6267\u884c\u7528\u6237\u8fdd\u89c4\u5904\u7406\u5b9a\u65f6\u4efb\u52a1==========");
        }
        if (!CollectionUtils.isEmpty(expiredTaskList)) {
            for (UserBlockExpiredTaskEntity userBlockExpiredTaskEntity : expiredTaskList) {
                List authCodeIndex = JSON.parseArray((String)userBlockExpiredTaskEntity.getAuthIndex(), Integer.class);
                authCodeIndex.forEach(index -> {
                    AuthCodeEnum codeEnum = AuthCodeEnum.getByIndex((Integer)index);
                    if (Objects.nonNull(codeEnum)) {
                        this.userAuthCodeService.removeAuthCode(userBlockExpiredTaskEntity.getUserId(), codeEnum);
                    }
                });
                if (log.isDebugEnabled()) {
                    log.debug("\u79fb\u9664\u7528\u6237\u6743\u9650\u5b9a\u4efb\u52a1\u6267\u884c\u6210\u529f,\u4efb\u52a1\u6570\u636e:[{}]", (Object)JSONObject.toJSONString((Object)userBlockExpiredTaskEntity));
                }
                this.userBlockExpiredTaskService.removeTask(userBlockExpiredTaskEntity.getUserId());
            }
        }
    }

    public String jobDesc() {
        return "\u7528\u6237\u8fdd\u89c4\u5904\u7406\u5b9a\u65f6\u4efb\u52a1";
    }

    public String author() {
        return "\u738b\u5fd7\u8fdc";
    }
}

