package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.service.ActivityService;
import com.bxm.localnews.activity.vo.Activity;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.RdPage;
import com.bxm.newidea.component.controller.BaseController;
import com.github.pagehelper.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "2-05 活动查询", description = "活动数据相关操作")
@RestController
@RequestMapping("api/activity")
public class ActivityController extends BaseController {

    @Resource
    private ActivityService activityService;

    @ApiOperation(value = "2-05-1 分页获取活动列表", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "current", value = "页码", required = true),
            @ApiImplicitParam(name = "pageSize", value = "数目", required = true)
    })
    @GetMapping("selectPageList")
    @TouTiaoAuth
    public Json<Page<Activity>> selectPageList(Integer current, Integer pageSize) {
        Page<Activity> page = this.activityService.selectPageList(current, pageSize);
        return ResultUtil.genSuccessResultWithPage(page, new RdPage(page));
    }

}
