package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.service.InviteRelationService;
import com.bxm.localnews.activity.vo.ApprenticeInfoVo;
import com.bxm.localnews.activity.vo.PrenticeRankingModel;
import com.bxm.localnews.activity.vo.ShareMessageVo;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.service.UserRewardStatService;
import com.bxm.localnews.user.vo.PrenticeStatModel;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Api(tags = "2-03 师徒相关", description = "师徒相关操作")
@RestController
@RequestMapping("api/apprenticeship")
public class ApprenticeshipController {

    @Resource
    private UserRewardStatService userRewardStatService;

    @Resource
    private InviteRelationService inviteRelationService;

    @ApiOperation(value = "2-03-1 我的徒弟界面", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "myPrentice")
    @TouTiaoAuth
    public Json<PrenticeStatModel> myPrentice(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.prenticeStatDaily(userId);
    }

    @ApiOperation(value = "2-03-2 我的徒孙界面", notes = "", hidden = true)
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "myDispline")
    @TouTiaoAuth
    public Json<PrenticeStatModel> myDispline(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.displineStatDaily(userId);
    }

    @ApiOperation(value = "2-03-4 唤醒完成", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "ids", value = "id数组", required = true),
    })
    @PostMapping(value = "awakePrentices")
    @TouTiaoAuth
    public Json awake(@RequestParam(name = "ids") Long[] ids,
                      @RequestParam(name = "userId") Long userId) {
        return this.inviteRelationService.awakePrenticesSuccess(ids, userId);
    }

    @ApiOperation(value = "2-03-3 高手排行榜", notes = "")
    @PostMapping(value = "topRanking")
    @TouTiaoAuth
    public Json<List<PrenticeRankingModel>> topRanking() {
        return this.userRewardStatService.topRanking();
    }

    @ApiOperation(value = "2-03-5 一键唤醒", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "awakeAll")
    @TouTiaoAuth
    public Json awakeAll(@RequestParam(name = "userId") Long userId, HttpServletRequest request) {
        return this.inviteRelationService.awakeAllPrentices(userId, WebUtils.getIpAddr(request));
    }

    @ApiOperation(value = "2-03-6 唤醒徒儿", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "prenticeId", value = "徒弟ID", required = true)
    })
    @PostMapping(value = "awakePrentice")
    @TouTiaoAuth
    public Json awakePrentice(@RequestParam(name = "userId") Long userId,
                              @RequestParam(name = "prenticeId") Long prenticeId,
                              HttpServletRequest request) {
        return this.inviteRelationService.awakePrentice(userId, prenticeId, request.getRemoteAddr());
    }

    @ApiOperation(value = "2-03-7 获取邀请收徒信息", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "getShareApprenticeMessage")
    @TouTiaoAuth
    public Json<ShareMessageVo> getShareApprenticeMessage(@RequestParam(value = "userId") Long userId) {
        return this.inviteRelationService.getShareMessage(userId, AppConst.SHARE_INFO_TYPE.APPRENTICE);
    }

    @ApiOperation(value = "2-03-8 获取唤醒信息", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "getShareAwakenMessage")
    @TouTiaoAuth
    public Json<ShareMessageVo> getShareAwakenMessage(@RequestParam(value = "userId") Long userId) {
        return this.inviteRelationService.getShareMessage(userId, AppConst.SHARE_INFO_TYPE.AWAKEN);
    }

    @ApiOperation(value = "2-03-9 拜师界面信息", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "type", value = "type 1：站内扫-拜师 2：站外扫注册并拜师界面", allowableValues = "1,2",
                    required = true)
    })
    @PostMapping(value = "getApprenticeInfo")
    @ResponseBody
    public Json<ApprenticeInfoVo> getApprenticeInfo(@RequestParam(value = "userId") Long userId,
                                                    @RequestParam(value = "type") Byte type) {
        return this.inviteRelationService.getApprenticeInfo(userId, type);
    }

}
