/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.config.ActivityProperties;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.CodeCreaterFactory;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.param.QrCodeParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-04 h5\u76f8\u5173\u63a5\u53e3"}, description="h5\u76f8\u5173\u63a5\u53e3\u64cd\u4f5c")
@RefreshScope
@RestController
@RequestMapping(value={"/api/h5"})
public class H5Controller
extends BaseController {
    private RedisHashMapAdapter redisHashMapAdapter;
    private BizConfigProperties bizConfigProperties;
    private AliyunOSSService aliyunOSSService;
    private ActivityProperties activityProperties;

    @Autowired
    public H5Controller(RedisHashMapAdapter redisHashMapAdapter, ActivityProperties activityProperties, BizConfigProperties bizConfigProperties, AliyunOSSService aliyunOSSService) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.activityProperties = activityProperties;
        this.bizConfigProperties = bizConfigProperties;
        this.aliyunOSSService = aliyunOSSService;
    }

    @ApiOperation(value="2-04-1 \u83b7\u53d6\u7528\u6237\u5206\u4eab\u7684\u56fe\u7247", notes="")
    @ApiImplicitParam(name="userId", value="\u5206\u4eab\u7684\u7528\u6237ID")
    @GetMapping(value={"share/img/{userId}"})
    public Json<String> getShareImge(@PathVariable String userId) {
        String shareImg = (String)this.redisHashMapAdapter.get(RedisConfig.USER_SHARE_IMAGES, userId, String.class);
        if (StringUtils.isBlank((CharSequence)shareImg)) {
            try {
                shareImg = this.gen(userId);
                if (StringUtils.isNotBlank((CharSequence)shareImg)) {
                    this.redisHashMapAdapter.put(RedisConfig.USER_SHARE_IMAGES, userId, (Object)shareImg);
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return Json.build((Object)shareImg);
    }

    private String getUrl(String userId) {
        String h5Host = this.bizConfigProperties.getH5ServerHost();
        return h5Host + "/downloadWx.html?userId=" + userId + "&chnl=invitenew";
    }

    private String gen(String userId) throws IOException {
        String rootPath = this.bizConfigProperties.getTempDir() + File.separator;
        String url = this.getUrl(userId);
        File qrCodeFile = new File(rootPath + userId + ".jpg");
        QrCodeParam param = new QrCodeParam();
        param.setWidth(236);
        param.setHeight(236);
        param.setImageFile(qrCodeFile);
        param.setMessage(url);
        param.setLogoPath(this.getIconFile().getPath());
        CodeCreaterFactory.createQrCode((QrCodeParam)param);
        String suffix = "png";
        File sourceFile = this.getSourceFile();
        BufferedImage finalImgBuffer = this.watermark(sourceFile, qrCodeFile, 256, 923, 1.0f);
        String finalFileName = userId + "_final." + suffix;
        File finalFile = new File(rootPath + finalFileName);
        ImageIO.write((RenderedImage)finalImgBuffer, suffix, finalFile);
        String dateStr = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        String imageUrl = this.aliyunOSSService.upload((InputStream)FileUtils.openInputStream((File)finalFile), "share/" + dateStr + "/" + userId + "." + suffix);
        qrCodeFile.delete();
        finalFile.delete();
        return imageUrl;
    }

    private File getSourceFile() {
        return this.getAliyunOssFile(this.activityProperties.getShareSourceImgUrl());
    }

    private File getIconFile() {
        return this.getAliyunOssFile(this.bizConfigProperties.getAppIconUrl());
    }

    private File getAliyunOssFile(String aliyunFilePath) {
        boolean result;
        File appFile;
        String fileName = StringUtils.substringAfterLast((String)aliyunFilePath, (String)"/");
        String separator = "";
        if (!this.bizConfigProperties.getTempDir().endsWith("/") && !this.bizConfigProperties.getTempDir().endsWith("\\")) {
            separator = File.separator;
        }
        if ((appFile = new File(this.bizConfigProperties.getTempDir() + separator + fileName)).exists()) {
            return appFile;
        }
        File tempDirFile = new File(this.bizConfigProperties.getTempDir());
        if (!tempDirFile.exists() && !(result = tempDirFile.mkdirs())) {
            this.logger.error("\u521b\u5efa[{}]\u76ee\u5f55\u5931\u8d25\uff0c\u53ef\u80fd\u6ca1\u6709\u6743\u9650", (Object)this.bizConfigProperties.getTempDir());
        }
        try {
            FileUtils.copyURLToFile((URL)new URL(aliyunFilePath), (File)appFile);
        }
        catch (IOException e) {
            this.logger.error(aliyunFilePath + "\u914d\u7f6e\u7684\u4e0b\u8f7d\u6587\u4ef6\u8def\u5f84\u4e0d\u6b63\u786e", (Throwable)e);
        }
        return appFile;
    }

    private BufferedImage watermark(File file, File waterFile, int x, int y, float alpha) throws IOException {
        BufferedImage buffImg = ImageIO.read(file);
        BufferedImage waterImg = ImageIO.read(waterFile);
        Graphics2D g2d = buffImg.createGraphics();
        int waterImgWidth = waterImg.getWidth();
        int waterImgHeight = waterImg.getHeight();
        g2d.setComposite(AlphaComposite.getInstance(10, alpha));
        g2d.drawImage(waterImg, x, y, waterImgWidth, waterImgHeight, null);
        g2d.dispose();
        return buffImg;
    }
}

