package com.bxm.localnews.activity.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import com.bxm.localnews.activity.service.InviteRelationService;
import com.bxm.localnews.activity.vo.ApprenticeInfoVo;
import com.bxm.localnews.activity.vo.ShareMessageVo;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.service.UserRewardStatService;
import com.bxm.newidea.component.util.WebUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@Api(tags = "2-03 师徒相关", description = "师徒相关操作")
@RestController
@RequestMapping("api/apprenticeship")
public class ApprenticeshipController {

    @Resource
    private UserRewardStatService userRewardStatService;

    @Resource
    private InviteRelationService inviteRelationService;

    @ApiOperation(value = "2-03-5 一键唤醒", notes = "必须传入token")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "awakeAll")
    @TouTiaoAuth
    public Json awakeAll(@RequestParam(name = "userId") Long userId, HttpServletRequest request) {
        return this.inviteRelationService.awakeAllPrentices(userId, WebUtils.getIpAddr(request));
    }

    @ApiOperation(value = "2-03-7 获取邀请收徒信息", notes = "必须传入token")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "getShareApprenticeMessage")
    @TouTiaoAuth
    public Json<ShareMessageVo> getShareApprenticeMessage(@RequestParam(value = "userId") Long userId) {
        return this.inviteRelationService.getShareMessage(userId, AppConst.SHARE_INFO_TYPE.APPRENTICE);
    }

    @ApiOperation(value = "2-03-8 获取唤醒信息", notes = "必须传入token")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "getShareAwakenMessage")
    @TouTiaoAuth
    public Json<ShareMessageVo> getShareAwakenMessage(@RequestParam(value = "userId") Long userId) {
        return this.inviteRelationService.getShareMessage(userId, AppConst.SHARE_INFO_TYPE.AWAKEN);
    }

    @ApiOperation(value = "2-03-9 拜师界面信息", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "type", value = "type 1：站内扫-拜师 2：站外扫注册并拜师界面", allowableValues = "1,2",
                    required = true)
    })
    @PostMapping(value = "getApprenticeInfo")
    @ResponseBody
    public Json<ApprenticeInfoVo> getApprenticeInfo(@RequestParam(value = "userId") Long userId,
                                                    @RequestParam(value = "type") Byte type) {
        return this.inviteRelationService.getApprenticeInfo(userId, type);
    }

}
