package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.MovieDTO;
import com.bxm.localnews.activity.param.MovieParam;
import com.bxm.localnews.activity.service.MovieService;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import static com.bxm.localnews.common.constant.RespCode.BAD_REQUEST;

@Api(tags = "2-10 电影票相关接口", description = "包括电影票的相关接口操作")
@RestController
@RequestMapping("/api/movie")
public class MovieController extends BaseController {

    @Autowired
    private MovieService movieService;

    @ApiOperation(value = "2-10-1 电影票提示", notes = "当用户获得电影票后且不过期，则在VIP详情中显示'您有一张电影票可以使用'，true为显示")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "用户id", required = true)
    })
    @GetMapping("/prompt/{id}")
    public Json<Boolean> getMoviePrompt(@PathVariable Long id) {
        return Json.build(movieService.isHasMovie(id));
    }

    @ApiOperation(value = "2-10-2 电影票详情", notes = "当用户进入查看电影票详情时显示电影票的兑换码和商铺相关信息")
    @GetMapping("/detail")
    public Json<MovieDTO> getMovieDetail(MovieParam movieParam) {
        if (null == movieParam.getUserId()) {
            return ResultUtil.genFailedResult(BAD_REQUEST,"参数错误");
        }
        return Json.build(movieService.getMovieDetail(movieParam));
    }

    @ApiOperation(value = "2-10-3 查看右上角VIP小红点(电影票)", notes = "当用户获得电影票后，在右上角VIP入口位置出现气泡 2.气泡出现状态下，点击该入口后气泡消失，不再出现；若不点击，则一直存在")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @PostMapping("/notice")
    @TouTiaoAuth
    public Json updateMovieVipNotice(@RequestParam Long userId) {
        if (null == userId) {
            return ResultUtil.genFailedResult(BAD_REQUEST,"参数错误");
        }
        movieService.updateMovieVipNotice(userId);
        return ResultUtil.genSuccessResult();
    }

}
