/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.common.constant.PrivilegeStatusEnum;
import com.bxm.localnews.activity.dto.ParticipateResultDTO;
import com.bxm.localnews.activity.dto.PrivilegeDTO;
import com.bxm.localnews.activity.dto.PrivilegeListDTO;
import com.bxm.localnews.activity.dto.PrivilegeOverviewDTO;
import com.bxm.localnews.activity.dto.PrivilegeParticipantDTO;
import com.bxm.localnews.activity.dto.WinnerDTO;
import com.bxm.localnews.activity.param.MerchantParam;
import com.bxm.localnews.activity.param.ParticipatePrivilegeParam;
import com.bxm.localnews.activity.param.PrivilegeDetailParam;
import com.bxm.localnews.activity.param.PrivilegeOverviewParam;
import com.bxm.localnews.activity.param.PrivilegeParam;
import com.bxm.localnews.activity.param.PrivilegeParticipantParam;
import com.bxm.localnews.activity.param.PrivilegeRecommendParam;
import com.bxm.localnews.activity.param.PrivilegeWinnerParam;
import com.bxm.localnews.activity.service.MerchantService;
import com.bxm.localnews.activity.service.PrivilegeParticipantService;
import com.bxm.localnews.activity.service.PrivilegeService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.facade.SmsSupplyFeignService;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-06 \u4f18\u60e0\u6d3b\u52a8\u76f8\u5173\u63a5\u53e3"}, description="\u5305\u62ec\u6d3b\u52a8\u7684\u76f8\u5173\u63a5\u53e3\u64cd\u4f5c")
@RestController
@RequestMapping(value={"/api/privileges"})
public class PrivilegeController {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeController.class);
    @Resource
    private PrivilegeService privilegeService;
    @Resource
    private PrivilegeParticipantService privilegeParticipantService;
    @Resource
    private MerchantService merchantService;
    @Resource
    private SmsSupplyFeignService smsSupplyFeignService;
    @Resource
    private LocationFacadeService locationFacadeService;

    @ApiOperation(value="2-06-1 \u83b7\u5f97\u4f18\u60e0\u6d3b\u52a8\u5217\u8868", notes="\u5982\u679c\u8be5\u57ce\u5e02\u5f00\u901aVIP,\u7528\u6237\u53ef\u4ee5\u5728VIP\u680f\u76ee\u53ef\u4ee5\u770b\u5230\u8be5\u57ce\u5e02VIP\u6240\u652f\u6301\u7684\u5e97\u94fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="longitude", value="\u7ecf\u5ea6", required=false), @ApiImplicitParam(name="latitude", value="\u7eac\u5ea6", required=false), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, dataType="long"), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true)})
    @GetMapping
    public Json<PageWarper<PrivilegeListDTO>> listPrivileges(@Validated PrivilegeParam privilegeParam, BasicParam basicParam) {
        return Json.build((Object)this.privilegeService.listPrivilege(privilegeParam, basicParam));
    }

    @ApiOperation(value="2-06-2 \u83b7\u5f97\u4f18\u60e0\u6d3b\u52a8\u8be6\u60c5", notes="\u663e\u793a\u4eab\u53d7VIP\u6298\u6263\u7684\u5e97\u94fa\u8be6\u60c5,\u5176\u4e2d\u5305\u542b\u5e97\u94fa\u540d\u3001\u8425\u4e1a\u65f6\u95f4\u3001\u5730\u5740\u3001\u7535\u8bdd\u3001\u6298\u6263\u3001\u8be6\u7ec6\u5185\u5bb9\u7b49")
    @GetMapping(value={"/detail"})
    public Json<PrivilegeDTO> getPrivilegeById(@Validated PrivilegeDetailParam privilegeDetailParam) {
        PrivilegeDTO privilegeDTO = this.privilegeService.getPrivilegeDetail(privilegeDetailParam);
        if (privilegeDTO == null) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        return Json.build((Object)privilegeDTO);
    }

    @ApiOperation(value="2-06-3 \u83b7\u5f97\u6d3b\u52a8\u62bd\u5956\u7ed3\u679c\u540d\u5355", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="privilegeId", value="\u6d3b\u52a8id", dataType="long", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=false)})
    @GetMapping(value={"/result"})
    public Json<List<WinnerDTO>> getPrivilegeWinnersById(@Validated PrivilegeWinnerParam privilegeWinnerParam) {
        boolean isDisplayCommodityCode = true;
        if (privilegeWinnerParam.getPlatform() == 3) {
            isDisplayCommodityCode = false;
        }
        return Json.build((Object)this.privilegeService.listWinnerByPrivilegeId(privilegeWinnerParam.getPrivilegeId(), privilegeWinnerParam.getUserId(), isDisplayCommodityCode));
    }

    @ApiOperation(value="2-06-4 \u53c2\u52a0\u6d3b\u52a8", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="privilegeId", value="\u6d3b\u52a8id", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="inviteUserId", value="\u9080\u8bf7\u4eba\u7528\u6237ID", required=false), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true)})
    @TouTiaoAuth
    @PostMapping(value={"/participate"})
    public Json<ParticipateResultDTO> participate(@Validated ParticipatePrivilegeParam participatePrivilegeParam, HttpServletRequest httpServletRequest) {
        PrivilegeDetailParam privilegeDetailParam = new PrivilegeDetailParam();
        privilegeDetailParam.setUserId(participatePrivilegeParam.getUserId());
        privilegeDetailParam.setId(participatePrivilegeParam.getPrivilegeId());
        PrivilegeDTO privilegeDTO = this.privilegeService.getPrivilegeDetail(privilegeDetailParam);
        if (privilegeDTO == null) {
            return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(1))).setCode(RespCode.BAD_REQUEST).setErrorMsg("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        PrivilegeStatusEnum statusEnum = PrivilegeStatusEnum.getEnumByStatus((Integer)privilegeDTO.getStatus());
        switch (statusEnum) {
            case END: {
                return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(1))).setCode(RespCode.BAD_REQUEST).setErrorMsg("\u6d3b\u52a8\u5df2\u7ed3\u675f");
            }
            case CANCEL: {
                return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(1))).setCode(RespCode.BAD_REQUEST).setErrorMsg("\u6d3b\u52a8\u5df2\u53d6\u6d88");
            }
            case WAIT_TO_START: {
                return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(1))).setCode(RespCode.BAD_REQUEST).setErrorMsg("\u6d3b\u52a8\u672a\u5f00\u59cb");
            }
            case PROCESSING: {
                break;
            }
            default: {
                return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(3))).setCode(RespCode.INTERNAL_SERVER_ERROR).setErrorMsg("\u6d3b\u52a8\u9519\u8bef");
            }
        }
        if (participatePrivilegeParam.getUserId().equals(participatePrivilegeParam.getInviteUserId())) {
            return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(1))).setCode(RespCode.BAD_REQUEST).setErrorMsg("\u4e0d\u80fd\u9080\u8bf7\u81ea\u5df1");
        }
        if (privilegeDTO.getParticipated().booleanValue()) {
            return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(1))).setCode(RespCode.BAD_REQUEST).setErrorMsg("\u5df2\u7ecf\u53c2\u52a0\u8fc7");
        }
        if (participatePrivilegeParam.getPlatform() != 3 && !privilegeDTO.getGlobalFlag().booleanValue() && !this.locationFacadeService.compareLocationCode(participatePrivilegeParam.getAreaCode(), privilegeDTO.getAreaCodeList())) {
            return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(2))).setCode(RespCode.BAD_REQUEST).setErrorMsg("\u4e0d\u80fd\u8de8\u5730\u57df\u53c2\u52a0\u6d3b\u52a8");
        }
        String ip = WebUtils.getIpAddr((HttpServletRequest)httpServletRequest);
        int result = this.privilegeParticipantService.saveParticipantPrivilege(participatePrivilegeParam.getUserId(), participatePrivilegeParam.getInviteUserId(), participatePrivilegeParam.getPrivilegeId(), ip);
        return Json.build((Object)new ParticipateResultDTO(Integer.valueOf(0)));
    }

    @ApiOperation(value="2-06-5 \u5f53\u524d\u7528\u6237\u9080\u8bf7\u7684\u597d\u53cb\u5217\u8868", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="privilegeId", value="\u6d3b\u52a8id", dataType="long", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long", required=true)})
    @TouTiaoAuth
    @GetMapping(value={"/invitees"})
    public Json<PageWarper<PrivilegeParticipantDTO>> getInviteesByUserId(@Validated PrivilegeParticipantParam privilegeParticipantParam) {
        PageWarper privilegeParticipantDTOPageWarper = this.privilegeService.listPrivilegeParticipantByInvite(privilegeParticipantParam);
        return Json.build((Object)privilegeParticipantDTOPageWarper);
    }

    @ApiOperation(value="2-06-6 \u83b7\u5f97\u63a8\u8350\u6d3b\u52a8\u5217\u8868", notes="\u83b7\u53d6\u5168\u56fd\u548c\u5206\u4eab\u7528\u6237(\u9080\u8bf7\u4eba)\u6240\u5728\u5730\u7684\u6d3b\u52a8\uff0c\u652f\u6301\u53bb\u6389\u5206\u4eab\u7684\u5f53\u524d\u6d3b\u52a8\u548c\u7528\u6237\u5df2\u53c2\u52a0\u7684\u6d3b\u52a8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="longitude", value="\u7ecf\u5ea6", required=false), @ApiImplicitParam(name="latitude", value="\u7eac\u5ea6", required=false), @ApiImplicitParam(name="privilegeId", value="\u5f53\u524d\u6d3b\u52a8ID", required=false, dataType="long"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, dataType="long"), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=false)})
    @GetMapping(value={"/recommend"})
    public Json<PageWarper<PrivilegeListDTO>> listRecommendPrivileges(PrivilegeRecommendParam privilegeRecommendParam) {
        return Json.build((Object)this.privilegeService.listRecommendPrivilege(privilegeRecommendParam));
    }

    @ApiOperation(value="2-06-7 \u5546\u5bb6\u62a5\u540d", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u5546\u5bb6\u540d\u5b57\uff08\u516c\u53f8\u540d\uff09", required=true), @ApiImplicitParam(name="type", value="\u5546\u5bb6\u7c7b\u578b", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="long"), @ApiImplicitParam(name="contractor", value="\u8054\u7cfb\u4eba\u59d3\u540d", required=true), @ApiImplicitParam(name="code", value="\u77ed\u4fe1\u9a8c\u8bc1\u7801", required=true), @ApiImplicitParam(name="phone", value="\u8054\u7cfb\u7535\u8bdd", required=true)})
    @PostMapping(value={"/merchant"})
    public Json newMerchant(@Validated MerchantParam merchantParam) {
        boolean result = this.smsSupplyFeignService.verifySmsCode(merchantParam.getPhone(), merchantParam.getCode(), SmsTemplateEnum.NORMAL_V_CODE);
        if (!result) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        log.debug("\u5546\u6237\u62a5\u540d\u4f20\u5165\u53c2\u6570:[{}]", (Object)JSONObject.toJSONString((Object)merchantParam));
        if (merchantParam.getPlatform() != 3 && merchantParam.getUserId() == null) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        int insertResult = this.merchantService.saveMerchant(merchantParam);
        return Json.build((Object)"\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="2-06-8 \u83b7\u53d6\u4f18\u60e0\u6d3b\u52a8\u56fe\u7247\u7684\u6587\u4ef6\u6d41", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6d3b\u52a8id", required=true, dataType="long"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, dataType="long")})
    @GetMapping(value={"/detail/img"})
    public void getPrivilegeImg(@RequestParam(value="id") Long id, @RequestParam(name="userId", required=false) Long userId, HttpServletResponse response) throws IOException {
        BufferedInputStream dis = null;
        FilterOutputStream fos = null;
        PrivilegeDetailParam privilegeDetailParam = new PrivilegeDetailParam();
        privilegeDetailParam.setUserId(userId);
        privilegeDetailParam.setId(id);
        PrivilegeDTO privilegeDTO = this.privilegeService.getPrivilegeDetail(privilegeDetailParam);
        if (privilegeDTO == null) {
            return;
        }
        String urlString = privilegeDTO.getShareBgUrl();
        String fileName = urlString.substring(urlString.lastIndexOf(47) + 1);
        try {
            int bytesRead;
            URL url = new URL(urlString);
            response.reset();
            String contentType = FileTypeEnum.getContentType((String)urlString.substring(urlString.lastIndexOf(46) + 1));
            response.setContentType(contentType);
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
            response.setHeader("Content-Length", String.valueOf(url.openConnection().getContentLength()));
            dis = new BufferedInputStream(url.openStream());
            fos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = dis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)fos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    @ApiOperation(value="2-06-9 \u83b7\u5f97\u67d0\u5730\u533a\u5185\u7684\u6240\u6709\u4f18\u60e0\u6d3b\u52a8", notes="\u5f53\u7528\u6237\u5728\u5f00\u901aVIP\u65f6,\u4f1a\u8fdb\u5165\u5f00\u901aVIP\u9875\u9762\uff0c\u5176\u4e2d\u4f1a\u663e\u793a\u8be5\u5730\u533a\u7684\u6240\u6709\u4f18\u60e0\u6d3b\u52a8\u4ee5\u5438\u5f15\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="longitude", value="\u7ecf\u5ea6", required=false), @ApiImplicitParam(name="latitude", value="\u7eac\u5ea6", required=false), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true)})
    @GetMapping(value={"/all"})
    public Json<List<PrivilegeOverviewDTO>> listAllPrivileges(@Validated PrivilegeOverviewParam privilegeParam) {
        return Json.build((Object)this.privilegeService.listAllPrivilege(privilegeParam));
    }
}

