package com.bxm.localnews.activity.controller;

import javax.annotation.Resource;

import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.activity.vo.BaskInfoMeta;
import com.bxm.localnews.activity.vo.MissionModel;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.vo.Json;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "2-02 个人任务相关接口", description = "包括新手任务和日常任务")
@RestController
@RequestMapping("api/mission")
public class MissionController {

    @Resource
    private MissionService missionService;

    @ApiOperation(value = "2-02-1 获取任务中心列表,包括个人任务和新手任务", notes = "")

    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = false),
    })
    @RequestMapping(value = "listMission", method = RequestMethod.POST)
    public Json<MissionModel> listMission(@RequestParam(value = "userId") Long userId, @RequestParam(value = "areaCode", required = false) String areaCode,
                                          @RequestParam(required = false) String curVer) {
        return this.missionService.listMissions(userId, areaCode, curVer);
    }

    @ApiOperation(value = "2-02-3 晒收入,获取用户基本信息", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "baskInfo", method = RequestMethod.POST)
    @TouTiaoAuth
    public Json<BaskInfoMeta> baskInfo(@RequestParam(value = "userId") Long userId) {
        return this.missionService.baskInfo(userId);
    }

}
