package com.bxm.localnews.activity.facade.controller;

import com.bxm.localnews.activity.service.VipFacadeService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2019/3/7 16:34
 * @desc
 */
@Api(tags = "2-91 [内部接口]vip相关接口")
@RestController
@RequestMapping("facade/activity/vip")
@Slf4j
public class VipFacadeController {

    @Autowired
    private VipFacadeService vipFacadeService;

    @ApiOperation(value = "2-91-1 保存vip访问记录", notes = "访问好友分享页面时")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "unionId", value = "用户微信唯一id", required = true)
    })
    @PostMapping("/save")
    public void saveVipViewRecord(@RequestParam("userId") Long userId, @RequestParam("unionId") String unionId) {
        vipFacadeService.saveVipViewRecord(userId, unionId);
    }

    @ApiOperation(value = "2-91-2 保存vip访问记录", notes = "访问好友分享页面时")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @GetMapping("/invitenum")
    public ResponseEntity<Integer> countVipByUser(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(vipFacadeService.countVipByUser(userId));
    }
}
