package com.bxm.localnews.activity.controller;

import java.util.List;

import com.bxm.localnews.activity.dto.CalendarSignDTO;
import com.bxm.localnews.activity.dto.SignDTO;
import com.bxm.localnews.activity.service.DailySignService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "2-01 每日签到接口", description = "签到必须登录后才可以访问")
@RestController
@RequestMapping("api/sign/public")
public class DailySignController {

    @Autowired
    private DailySignService dailySignService;

    @ApiOperation(value = "2-01-1 获取用户的签到记录", notes = "签到页面相关信息：除了日历签到列表信息，其余相关信息都在此接口返回")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @GetMapping(value = "signRecord")
    public Json<SignDTO> signRecord(@RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult(dailySignService.signRecord(userId));
    }

    @ApiOperation(value = "2-01-2 获取用户对应签到的月历", notes = "签到日历及其相关信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @GetMapping(value = "listSignRecord")
    public Json<List<CalendarSignDTO>> listSignRecord(@RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult(dailySignService.listSignRecord(userId));
    }

    @ApiOperation(value = "2-01-3 用户签到", notes = "用户进行签到---只针对当天签到")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @PostMapping()
    public Json<Boolean> userSign(@RequestParam(value = "userId") Long userId) {
        Message message = dailySignService.executeUserSign(userId);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult(message.getLashMessaage());
        }
        return ResultUtil.genSuccessResult(message.isSuccess());
    }

    @ApiOperation(value = "2-01-4 用户补签", notes = "用户进行补签---只针对昨日签到")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @PostMapping("/fill")
    public Json<Boolean> userFillSign(@RequestParam(value = "userId") Long userId) {
        Message message = dailySignService.executeUserFillSign(userId);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult(message.getLashMessaage());
        }
        return ResultUtil.genSuccessResult(message.isSuccess());
    }
}
