/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.CalendarSignDTO;
import com.bxm.localnews.activity.dto.SignDTO;
import com.bxm.localnews.activity.service.DailySignService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-01 \u6bcf\u65e5\u7b7e\u5230\u63a5\u53e3"}, description="\u7b7e\u5230\u5fc5\u987b\u767b\u5f55\u540e\u624d\u53ef\u4ee5\u8bbf\u95ee")
@RestController
@RequestMapping(value={"api/sign/public"})
public class DailySignController {
    @Autowired
    private DailySignService dailySignService;

    @ApiOperation(value="2-01-1 \u83b7\u53d6\u7528\u6237\u7684\u7b7e\u5230\u8bb0\u5f55", notes="\u7b7e\u5230\u9875\u9762\u76f8\u5173\u4fe1\u606f\uff1a\u9664\u4e86\u65e5\u5386\u7b7e\u5230\u5217\u8868\u4fe1\u606f\uff0c\u5176\u4f59\u76f8\u5173\u4fe1\u606f\u90fd\u5728\u6b64\u63a5\u53e3\u8fd4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @GetMapping(value={"signRecord"})
    public Json<SignDTO> signRecord(@RequestParam(value="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.dailySignService.signRecord(userId));
    }

    @ApiOperation(value="2-01-2 \u83b7\u53d6\u7528\u6237\u5bf9\u5e94\u7b7e\u5230\u7684\u6708\u5386", notes="\u7b7e\u5230\u65e5\u5386\u53ca\u5176\u76f8\u5173\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @GetMapping(value={"listSignRecord"})
    public Json<List<CalendarSignDTO>> listSignRecord(@RequestParam(value="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.dailySignService.listSignRecord(userId));
    }

    @ApiOperation(value="2-01-3 \u7528\u6237\u7b7e\u5230", notes="\u7528\u6237\u8fdb\u884c\u7b7e\u5230---\u53ea\u9488\u5bf9\u5f53\u5929\u7b7e\u5230")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @PostMapping
    public Json<Boolean> userSign(@RequestParam(value="userId") Long userId) {
        Message message = this.dailySignService.executeUserSign(userId);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult((String)message.getLashMessaage());
        }
        return ResultUtil.genSuccessResult((Object)message.isSuccess());
    }

    @ApiOperation(value="2-01-4 \u7528\u6237\u8865\u7b7e", notes="\u7528\u6237\u8fdb\u884c\u8865\u7b7e---\u53ea\u9488\u5bf9\u6628\u65e5\u7b7e\u5230")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @PostMapping(value={"/fill"})
    public Json<Boolean> userFillSign(@RequestParam(value="userId") Long userId) {
        Message message = this.dailySignService.executeUserFillSign(userId);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult((String)message.getLashMessaage());
        }
        return ResultUtil.genSuccessResult((Object)message.isSuccess());
    }
}

