package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.CouponDTO;
import com.bxm.localnews.activity.dto.CouponDetailDTO;
import com.bxm.localnews.activity.param.CouponParam;
import com.bxm.localnews.activity.service.CouponService;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "2-09 优惠券相关接口", description = "优惠券查看等接口")
@RestController
@RequestMapping("api/coupon")
public class CouponController extends BaseController {

    @Autowired
    private CouponService couponService;

    @ApiOperation(value = "2-09-1 获得优惠券列表", notes = "当用户不是VIP或者当前地区未开通VIP时，展示优惠券列表")
    @ApiImplicitParams({
    })
    @GetMapping
    public Json<PageWarper<CouponDTO>> listPrivileges(CouponParam couponParam) {
        return Json.build(couponService.listCoupon(couponParam));
    }

}
