package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.sign.*;
import com.bxm.localnews.activity.param.sign.*;
import com.bxm.localnews.activity.service.sign.DailySignNewService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 *
 * 3.8.0 需求 签到逻辑部分做了改动；签到页面移动到客户端
 *
 * @author pf.w
 * @date 2020/10/22 15:19
 **/

@Api(tags = "2-60 签到", description = "签到必须登录后才可以访问")
@RestController
@RequestMapping("{version}/activity/sign/")
public class DailySignNewController{

    @Resource
    private DailySignNewService dailySignNewService;

    @ApiOperation(value = "2-60-1 【v1】签到信息", notes = "签到信息", httpMethod = "GET",nickname = "王鹏飞")
    @GetMapping("/signInfo")
    @ApiVersion(1)
    public ResponseJson<DailySignDTO> signInfo(SignInfoParam signInfoParam){
        return ResponseJson.ok(dailySignNewService.signInfo(signInfoParam));
    }

    @ApiOperation(value = "2-60-2 【v1】今日是否已签到", notes = "今日是否已签到", httpMethod = "GET",nickname = "王鹏飞")
    @GetMapping("/signStatusToday")
    @ApiVersion(1)
    public ResponseJson<SignTodayDTO> signStatusToday(SignInfoParam signInfoParam){
        return ResponseJson.ok(dailySignNewService.signStatusToday(signInfoParam));
    }

    @ApiOperation(value = "2-60-3 【v1】签到提醒-开启关闭接口", notes = "签到提醒开启关闭接口", httpMethod = "POST",nickname = "王鹏飞")
    @PostMapping("/signWarningOperate")
    @ApiVersion(1)
    public ResponseJson<Boolean> signWarningOperate(@RequestBody SignWarningOperateParam param){
        return ResponseJson.ok(dailySignNewService.signWarningOperate(param));
    }

    @ApiOperation(value = "2-60-4 【v1】签到礼包信息", notes = "签到礼包信息", httpMethod = "GET",nickname = "王鹏飞")
    @GetMapping("/giftInfo")
    @ApiVersion(1)
    public ResponseJson<SignGiftInfoDTO> giftInfo(SignBasicParam param){
        return ResponseJson.ok(dailySignNewService.signGiftInfo(param));
    }

    @ApiOperation(value = "2-60-5 【v1】领取新人签到礼包", notes = "领取新人签到礼包", httpMethod = "POST",nickname = "王鹏飞")
    @PostMapping("/receiveGift")
    @ApiVersion(1)
    public ResponseJson<Boolean> receiveGift(@RequestBody ReceiveGiftParam param){
        return  ResponseJson.ok(dailySignNewService.receiveGift(param));
    }

    @ApiOperation(value = "2-60-6 【v1】签到日历", notes = "签到日历", httpMethod = "GET",nickname = "王鹏飞")
    @GetMapping("/listSignRecord")
    @ApiVersion(1)
    public ResponseJson<List<SignRecordListDTO>> listSignRecord(SignBasicParam param){
        return ResponseJson.ok(dailySignNewService.listSignRecord(param));
    }

    @ApiOperation(value = "2-60-7 【v1】补签", notes = "补签", httpMethod = "POST",nickname = "王鹏飞")
    @PostMapping("/fillSign")
    @ApiVersion(1)
    public ResponseJson<SignResultDTO> fillSign(@RequestBody FillSignParam param){
        return ResponseJson.ok(dailySignNewService.fillSign(param));
    }

    @ApiOperation(value = "2-60-8 【v1】签到", notes = "签到", httpMethod = "POST",nickname = "王鹏飞")
    @PostMapping("/doSign")
    @ApiVersion(1)
    public ResponseJson<SignResultDTO> doSign(@RequestBody SignBasicParam param){
        return ResponseJson.ok(dailySignNewService.doSign(param));
    }

    @ApiOperation(value = "2-60-9 【v1】签到后看视频翻倍奖励接口", notes = "签到后看视频翻倍奖励接口", httpMethod = "GET",nickname = "王鹏飞")
    @GetMapping("/signAfterVideoReward")
    @ApiVersion(1)
    public ResponseJson<List<SignRewardChooseDTO>> signAfterWatchVideoReward(SignRewardChooseParam param){
        return ResponseJson.ok(dailySignNewService.signAfterWatchVideoReward(param));
    }
}
