package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.common.config.BaoZhiPrivilegeProperties;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Controller

@RequestMapping("/p")
@Api(tags = "2-08 活动重定向")
public class MController {
    private static final Logger logger = LoggerFactory.getLogger(MController.class);

    @Resource
    private BaoZhiPrivilegeProperties baoZhiPrivilegeProperties;

    @Resource
    private BizLogService bizLogService;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Resource
    private BaseUrlFacadeService baseUrlFacadeService;

    /**
     * 根据活动id重定向到爆汁后台
     * @param id     活动id
     * @param source 渠道（wx，wb等）
     * @return
     */
    @ApiOperation(value = "2-08-1 根据活动id重定向到爆汁后台url")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动id", required = true),
            @ApiImplicitParam(name = "s", value = "渠道（微信，微博等）", required = true)
    })
    @GetMapping("/a")
    public String redirect2BZ(@RequestParam("id") String id,
                              @RequestParam("s") String source,
                              HttpServletRequest httpServletRequest) {
        Integer isOnline = baoZhiPrivilegeProperties.isOnline(source);
        if (isOnline == -1) {
            logger.error("SOURCE_ERROR:page_soure=" + source + "&id=" + id);
            return "redirect:" + baseUrlFacadeService.getDownloadUrl();
        }
        String redirect = baoZhiPrivilegeProperties.getBaozhi().get(id);
        if (!StringUtils.isEmpty(redirect)) {
            bizLogService.baozhiPrivilege(Long.valueOf(id), source, isOnline, WebUtils.getIpAddr(httpServletRequest));
            return "redirect:" + redirect;
        } else {
            logger.error("REDIRECT_ERROR:page_soure=" + source + "&id=" + id);
            return "redirect:" + baseUrlFacadeService.getDownloadUrl();
        }
    }

    @ApiOperation(value = "2-08-2 扫描地址下载跳转到应用宝")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "s", value = "请求来源，对应报表中的统计渠道", required = true),
            @ApiImplicitParam(name = "o", value = "会否在线，1表示线上渠道，0表示线下渠道", required = true),
            @ApiImplicitParam(name = "m", value = "商户ID，详见后台管理系统的商户管理", required = false),
            @ApiImplicitParam(name = "a", value = "区域编码", required = false)
    })
    @GetMapping
    public String redirect2YYB(@RequestParam(value = "m", required = false) String merchantId,
                               @RequestParam("s") String pageResource,
                               @RequestParam("o") int online,
                               @RequestParam(value = "a", required = false) String areaCode,
                               HttpServletRequest request) {
        if (((online != 0) && (online != 1))) {
            logger.error("参数错误：merchantId:{},pageResource:{},online:{},areacode:{}", merchantId, pageResource, online, areaCode);
        } else {
            bizLogService.scan(online, pageResource, merchantId, areaCode, WebUtils.getIpAddr(request));
        }
        return "redirect:" + baseUrlFacadeService.getDownloadYYBUrl();
    }
}
