package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.RankBriefMocDto;
import com.bxm.localnews.activity.dto.RankCompositeDTO;
import com.bxm.localnews.activity.param.RankParam;
import com.bxm.localnews.activity.rank.RankSelfService;
import com.bxm.localnews.activity.rank.RankService;
import com.bxm.localnews.activity.vo.InteractRankInfo;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Objects;

/**
 * @author pf.w
 */
@Api(tags = "2-21 排行榜相关接口", description = "排行榜相关接口")
@RestController
@RequestMapping("{version}/activity/public/rank")
public class RankController {

    @Autowired
    private RankService rankService;

    @Autowired
    private RankSelfService rankSelfService;

    @Autowired
    LocationFacadeService locationFacadeService;

    @ApiOperation(value = "2-21-1 [v1]榜单简略信息", notes = "获取简略的榜单信息，用于显示在个人中心")
    @GetMapping("brief")
    @ApiVersion(1)
    public ResponseJson<RankBriefMocDto> rankList(RankParam param) {
        LocationDetailDTO location = locationFacadeService.getInternalLocationByGeocode(param.getAreaCode(),param);
        param.setAreaCode(Objects.nonNull(location) ? location.getCode() : param.getAreaCode());

        return ResponseJson.ok(rankService.rankBriefList(param));
    }

    @ApiOperation(value = "2-21-2 [v1]完整榜单信息", notes = "获取完整的所有榜单信息，由服务端控制榜单的排序与是否展示的逻辑")
    @GetMapping("detail")
    @ApiVersion(1)
    public ResponseJson<RankCompositeDTO> rankDetailList(RankParam param) {
        LocationDetailDTO location = locationFacadeService.getInternalLocationByGeocode(param.getAreaCode(),param);
        param.setAreaCode(Objects.nonNull(location) ? location.getCode() : param.getAreaCode());

        return ResponseJson.ok(rankService.rankCompositeInfo(param));
    }

    @GetMapping("test")
    @ApiVersion(1)
    public ResponseJson<List<InteractRankInfo>> test(RankParam param){
        return ResponseJson.ok(rankSelfService.loadInteractRankFromDb(param.getAreaCode()));
    }
}
