package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.VoteDetailDTO;
import com.bxm.localnews.activity.param.VoteParam;
import com.bxm.localnews.activity.param.VotePinParam;
import com.bxm.localnews.activity.vote.VoteService;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "2-14 投票插件相关接口", description = "包括投票次数变更、保存投票、获取投票记录")
@RestController
@RequestMapping("activity/vote")
public class VoteController {

    private final VoteService voteService;

    @Autowired
    public VoteController(VoteService voteService) {
        this.voteService = voteService;
    }

    @ApiOperation(value = "2-14-1 增加投票次数", notes = "用户进行分享等行为后，增加可投票的次数")
    @PostMapping("add")
    public Json<VoteDetailDTO> add(VotePinParam param) {
        return Json.build(voteService.addTime(param));
    }

    @ApiOperation(value = "2-14-2 上报投票结果", notes = "用户进行投票操作后上报投票结果")
    @PostMapping("report")
    public Json<VoteDetailDTO> report(VoteParam param) {
        return Json.build(voteService.execVote(param));
    }
}
