package com.bxm.localnews.activity.facade.controller;

import com.bxm.localnews.activity.param.RecordWechatParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2019/3/7 16:34
 * @desc
 */
@Api(tags = "2-91 [内部接口]vip相关接口", hidden = true)
@RestController
@RequestMapping("facade/activity/vip")
@Slf4j
@Deprecated
public class VipFacadeController {


    @ApiOperation(value = "2-91-1 更新vip邀请记录", notes = "用户登陆vip")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "unionId", value = "用户微信唯一id", required = true)
    })
    @PostMapping("/save")
    public void saveVipViewRecord(@RequestParam("userId") Long userId,
                                  @RequestParam("unionId") String unionId,
                                  @RequestParam("platform") Integer platform) {
    }

    @ApiOperation(value = "2-91-2 获取vip访问记录", notes = "访问好友分享页面时")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @GetMapping("/invitenum")
    public ResponseEntity<Integer> countVipByUser(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(0);
    }

    @ApiOperation(value = "2-91-3 保存vip访问记录", notes = "访问好友分享页面时")
    @PostMapping("/save/view/record")
    public void saveVipViewRecord(@RequestBody RecordWechatParam recordWechatParam) {
    }
}
