package com.bxm.localnews.activity.facade.controller;

import com.bxm.localnews.activity.dto.VoteDetailDTO;
import com.bxm.localnews.activity.param.VotePinParam;
import com.bxm.localnews.activity.vote.VoteService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "2-93 [内部接口]投票插件相关接口")
@RestController
@RequestMapping("facade/activity/vote")
@Slf4j
public class VoteFacadeController {

    private final VoteService voteService;

    @Autowired
    public VoteFacadeController(VoteService voteService) {
        this.voteService = voteService;
    }

    @ApiOperation(value = "2-93-1 获取投票插件详情", notes = "相关业务使用到投票插件时，获取投票插件详情")
    @GetMapping
    public ResponseEntity<VoteDetailDTO> get(@RequestBody VotePinParam param) {
        return ResponseEntity.ok(voteService.syncAndGet(param));
    }
}
