/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.AppletAppTaskResultDTO;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.activity.vo.BaskInfoMeta;
import com.bxm.localnews.activity.vo.MissionModel;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-02 \u4e2a\u4eba\u4efb\u52a1\u76f8\u5173\u63a5\u53e3"}, description="\u5305\u62ec\u65b0\u624b\u4efb\u52a1\u548c\u65e5\u5e38\u4efb\u52a1")
@RestController
@RequestMapping(value={"api/mission"})
public class MissionController {
    private static final Logger log = LoggerFactory.getLogger(MissionController.class);
    @Resource
    private MissionService missionService;

    @ApiOperation(value="2-02-1 \u83b7\u53d6\u4efb\u52a1\u4e2d\u5fc3\u5217\u8868,\u5305\u62ec\u4e2a\u4eba\u4efb\u52a1\u548c\u65b0\u624b\u4efb\u52a1", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=false)})
    @RequestMapping(value={"listMission"}, method={RequestMethod.POST})
    public Json<MissionModel> listMission(@RequestParam(value="userId") Long userId, @RequestParam(value="areaCode", required=false) String areaCode, @RequestParam(required=false) String curVer, @RequestParam(value="platform") Integer platform) {
        return this.missionService.listMissions(userId, areaCode, curVer, platform);
    }

    @ApiOperation(value="2-02-3 \u6652\u6536\u5165,\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"baskInfo"}, method={RequestMethod.POST})
    @TouTiaoAuth
    public Json<BaskInfoMeta> baskInfo(@RequestParam(value="userId") Long userId) {
        return this.missionService.baskInfo(userId);
    }

    @ApiOperation(value="2-02-4 \u5b8c\u6210\u7279\u5b9a\u573a\u666f\u4efb\u52a1", notes="\u5c0f\u7a0b\u5e8f\u5b8c\u6210\u4efb\u52a1\u8c03\u7528\uff1a\u6536\u85cf(1104),\u5173\u6ce8\u5fae\u4fe1\u516c\u4f17\u53f7-0001,\u8f6c\u53d1\u672c\u5730\u65b0\u95fb-0002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="scene", value="\u573a\u666f\u503c", required=true)})
    @RequestMapping(value={"/sceneTask"}, method={RequestMethod.POST})
    public Json<AppletAppTaskResultDTO> completeSceneTask(@RequestParam(value="userId") Long userId, @RequestParam(value="scene") String scene) {
        return ResultUtil.genSuccessResult((Object)this.missionService.completeSceneTask(userId, scene));
    }

    @ApiOperation(value="2-02-5 \u5b8c\u6210\u6307\u5b9a\u7684\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u5b8c\u6210\u4efb\u52a1\u7684\u7528\u6237ID"), @ApiImplicitParam(name="taskName", value="\u4efb\u52a1\u7f16\u7801\uff0c\u770b\u89c6\u9891\u8d5a\u5c0f\u7ea2\u82b1\uff1aTASK_WATCH_VIDEO"), @ApiImplicitParam(name="relationId", value="\u5b8c\u6210\u4efb\u52a1\u5173\u8054\u7684ID")})
    @PostMapping(value={"comple"})
    public Json<NewsMissionRewardDto> compleTask(@RequestParam Long userId, @RequestParam String taskName, @RequestParam(required=false) String relationId, @RequestParam(required=false) String content) {
        TaskEnum task = null;
        try {
            task = TaskEnum.valueOf((String)taskName);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u7c7b\u578b[{}]\u4e0d\u5b58\u5728", (Object)taskName);
        }
        if (null == task) {
            return ResultUtil.genFailedResult((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        NewsMissionRewardDto reward = this.missionService.completeTask(userId, TaskEnum.valueOf((String)taskName), relationId, content);
        return ResultUtil.genSuccessResult((Object)reward);
    }
}

