/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.dto.RankBriefMocDto;
import com.bxm.localnews.activity.dto.RankCompositeDTO;
import com.bxm.localnews.activity.param.RankParam;
import com.bxm.localnews.activity.rank.RankSelfService;
import com.bxm.localnews.activity.rank.RankService;
import com.bxm.localnews.activity.vo.InteractRankInfo;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-21 \u6392\u884c\u699c\u76f8\u5173\u63a5\u53e3"}, description="\u6392\u884c\u699c\u76f8\u5173\u63a5\u53e3")
@RestController
@RequestMapping(value={"{version}/activity/public/rank"})
public class RankController {
    @Autowired
    private RankService rankService;
    @Autowired
    private RankSelfService rankSelfService;
    @Autowired
    LocationFacadeService locationFacadeService;

    @ApiOperation(value="2-21-1 [v1]\u699c\u5355\u7b80\u7565\u4fe1\u606f", notes="\u83b7\u53d6\u7b80\u7565\u7684\u699c\u5355\u4fe1\u606f\uff0c\u7528\u4e8e\u663e\u793a\u5728\u4e2a\u4eba\u4e2d\u5fc3")
    @GetMapping(value={"brief"})
    @ApiVersion(value=1)
    public ResponseJson<RankBriefMocDto> rankList(RankParam param) {
        LocationDetailDTO location = this.locationFacadeService.getInternalLocationByGeocode(param.getAreaCode(), (BasicParam)param);
        param.setAreaCode(Objects.nonNull(location) ? location.getCode() : param.getAreaCode());
        return ResponseJson.ok((Object)this.rankService.rankBriefList(param));
    }

    @ApiOperation(value="2-21-2 [v1]\u5b8c\u6574\u699c\u5355\u4fe1\u606f", notes="\u83b7\u53d6\u5b8c\u6574\u7684\u6240\u6709\u699c\u5355\u4fe1\u606f\uff0c\u7531\u670d\u52a1\u7aef\u63a7\u5236\u699c\u5355\u7684\u6392\u5e8f\u4e0e\u662f\u5426\u5c55\u793a\u7684\u903b\u8f91")
    @GetMapping(value={"detail"})
    @ApiVersion(value=1)
    public ResponseJson<RankCompositeDTO> rankDetailList(RankParam param) {
        LocationDetailDTO location = this.locationFacadeService.getInternalLocationByGeocode(param.getAreaCode(), (BasicParam)param);
        param.setAreaCode(Objects.nonNull(location) ? location.getCode() : param.getAreaCode());
        return ResponseJson.ok((Object)this.rankService.rankCompositeInfo(param));
    }

    @GetMapping(value={"test"})
    @ApiVersion(value=1)
    public ResponseJson<List<InteractRankInfo>> test(RankParam param) {
        return ResponseJson.ok((Object)this.rankSelfService.loadInteractRankFromDb(param.getAreaCode()));
    }
}

