/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.controller;

import com.bxm.localnews.activity.common.config.CommandRedPacketProperties;
import com.bxm.localnews.activity.dto.CommandResultDTO;
import com.bxm.localnews.activity.dto.MarkScoreDTO;
import com.bxm.localnews.activity.dto.MarkScorePublicDTO;
import com.bxm.localnews.activity.dto.PacketHistoryDTO;
import com.bxm.localnews.activity.dto.RedPacketContentDTO;
import com.bxm.localnews.activity.dto.RedPacketDTO;
import com.bxm.localnews.activity.dto.RedPacketGottenDTO;
import com.bxm.localnews.activity.dto.RedPacketItemDTO;
import com.bxm.localnews.activity.dto.RedPacketPublicDTO;
import com.bxm.localnews.activity.dto.RedPacketSentDTO;
import com.bxm.localnews.activity.dto.RedPacketShareDTO;
import com.bxm.localnews.activity.dto.RedPacketUpdateDTO;
import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.dto.WallRedPacketDTO;
import com.bxm.localnews.activity.param.ObtainHistoryParam;
import com.bxm.localnews.activity.param.RedPacketAddParam;
import com.bxm.localnews.activity.param.RedPacketUpdateParam;
import com.bxm.localnews.activity.param.WallRedPacketParam;
import com.bxm.localnews.activity.service.redpacket.command.CommandGradeService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketService;
import com.bxm.localnews.activity.vo.GradeResultBean;
import com.bxm.localnews.activity.vo.RedPacketTotalVo;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"2-12 \u53e3\u4ee4\u7ea2\u5305\u76f8\u5173\u63a5\u53e3"}, description="\u53e3\u4ee4\u7ea2\u5305\u7684\u76f8\u5173\u64cd\u4f5c\u63a5\u53e3\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/redpacket"})
public class RedPacketController {
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketController.class);
    @Autowired
    private RedPacketService redPacketService;
    @Autowired
    private CommandGradeService commandGradeService;
    @Autowired
    private CommandRedPacketProperties commandRedPacketProperties;

    @ApiOperation(value="2-12-1 \u7ea2\u5305\u8bb0\u5f55\u91d1\u989d\u6c47\u603b\u63a5\u53e3", notes="\u83b7\u53d6\u7528\u6237\u53d1\u7ea2\u5305\u8bb0\u5f55\u548c\u9886\u7ea2\u5305\u8bb0\u5f55\u7684\u603b\u91d1\u989d\u548c\u603b\u8bb0\u5f55\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="owner", value="\u62e5\u6709\u6743\u9650(1\uff1a\u6211\u53d1\u7684\uff0c2\uff1a\u6211\u9886\u7684)", dataType="int", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true)})
    @GetMapping(value={"/record/total"})
    public Json<RedPacketTotalVo> getTotalRecord(@RequestParam(value="owner") Integer owner, @RequestParam(value="userId") Long userId) {
        return Json.build((Object)this.redPacketService.getTotalRecordByUser(owner, userId));
    }

    @ApiOperation(value="2-12-2 \u6211\u53d1\u9001\u7684\u7ea2\u5305\u8bb0\u5f55\u63a5\u53e3", notes="\u83b7\u53d6\u7528\u6237\u53d1\u8fc7\u7684\u7ea2\u5305\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true), @ApiImplicitParam(name="current", value="\u5f53\u524d\u9875", dataType="int", required=true), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u5927\u5c0f", dataType="int", required=true)})
    @GetMapping(value={"/record/sent"})
    public Json<PageWarper<RedPacketSentDTO>> getSentRecord(@RequestParam(value="userId") Long userId, @RequestParam(value="current") Integer current, @RequestParam(value="pageSize") Integer pageSize) {
        return Json.build((Object)this.redPacketService.listSentRecord(userId, current, pageSize));
    }

    @ApiOperation(value="2-12-3 \u6211\u9886\u53d6\u7684\u7ea2\u5305\u8bb0\u5f55\u63a5\u53e3", notes="\u83b7\u53d6\u7528\u6237\u9886\u53d6\u8fc7\u7684\u7ea2\u5305\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true), @ApiImplicitParam(name="current", value="\u5f53\u524d\u9875", dataType="int", required=true), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u5927\u5c0f", dataType="int", required=true)})
    @GetMapping(value={"/record/gotten"})
    public Json<PageWarper<RedPacketGottenDTO>> getGottenRecord(@RequestParam(value="userId") Long userId, @RequestParam(value="current") Integer current, @RequestParam(value="pageSize") Integer pageSize) {
        return Json.build((Object)this.redPacketService.listGottenRecord(userId, current, pageSize));
    }

    @ApiOperation(value="2-12-4 \u65b0\u589e\u7ea2\u5305\u63a5\u53e3\uff08\u8fd4\u56de\u7ea2\u5305id\uff09", notes="\u6dfb\u52a0\u53e3\u4ee4\u7ea2\u5305\u4fe1\u606f\uff08\u8fd4\u56de\u7ea2\u5305id\uff09")
    @PostMapping(value={"/add"})
    public Json<Long> addRedPacket(RedPacketAddParam redPacketAddParam) {
        return Json.build((Object)this.redPacketService.insertRedPacket(redPacketAddParam));
    }

    @ApiOperation(value="2-12-5 \u4fee\u6539\u7ea2\u5305\u63a5\u53e3", notes="\u4fee\u6539\u53e3\u4ee4\u7ea2\u5305\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public Json<Boolean> updateRedPacket(RedPacketUpdateParam redPacketUpdateParam, Integer platform) {
        Boolean result = this.redPacketService.updateRedPacket(redPacketUpdateParam, platform);
        return Json.build((Object)result);
    }

    @ApiOperation(value="2-12-6 \u83b7\u53d6\u5355\u4e2a\u7ea2\u5305\u4fee\u6539\u4fe1\u606f\u63a5\u53e3", notes="\u83b7\u53d6\u5355\u4e2a\u7ea2\u5305\u4fe1\u606f\u7528\u4e8e\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true)})
    @PostMapping(value={"/get/rpfu"})
    public Json<RedPacketUpdateDTO> getRedPacketById(@RequestParam(value="rpId") Long rpId, @RequestParam(value="userId") Long userId) {
        RedPacketUpdateDTO result = this.redPacketService.getRedPacketById(rpId, userId);
        if (null == result) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"red packet not exist");
        }
        return Json.build((Object)result);
    }

    @ApiOperation(value="2-12-7 \u83b7\u53d6\u53e3\u4ee4\u6a21\u677f\u63a5\u53e3", notes="\u83b7\u53d6\u6240\u7ea2\u5305\u53e3\u4ee4\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true)})
    @PostMapping(value={"/get/content"})
    public Json<List<RedPacketContentDTO>> getContentList(@RequestParam(value="userId") Long userId) {
        List result = this.redPacketService.listRedPacketContent(userId);
        if (null == result) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"the word of command is empty");
        }
        return Json.build((Object)result);
    }

    @ApiOperation(value="2-12-8 \u83b7\u53d6\u7ea2\u5305\u914d\u7f6e\u63a5\u53e3", notes="\u83b7\u53d6\u53ef\u53d1\u9001\u7684\u7ea2\u5305\u91d1\u548c\u548c\u6570\u91cf\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true)})
    @PostMapping(value={"/get/item"})
    public Json<List<RedPacketItemDTO>> getItemList(@RequestParam(value="userId") Long userId) {
        List result = this.redPacketService.listRedPacketItem(userId);
        if (null == result) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"the template is empty");
        }
        return Json.build((Object)result);
    }

    @ApiOperation(value="2-12-9 \u83b7\u53d6\u5206\u4eab\u4fe1\u606f\u63a5\u53e3", notes="\u83b7\u53d6\u7528\u4e8e\u5206\u4eab\u7684\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true), @ApiImplicitParam(name="type", value="\u7c7b\u578b\uff081\uff1a\u672a\u53c2\u4e0e\u30012\uff1a\u5df2\u53c2\u4e0e\uff09", dataType="int", required=true), @ApiImplicitParam(name="nickname", value="\u5206\u4eab\u4eba\u6635\u79f0", dataType="string", required=true)})
    @PostMapping(value={"/get/share"})
    public Json<RedPacketShareDTO> getShareInfo(@RequestParam(value="rpId") Long rpId, @RequestParam(value="userId") Long userId, @RequestParam(value="type") Integer type, @RequestParam(value="nickname") String nickname) {
        RedPacketShareDTO result = this.redPacketService.getShareInfo(rpId, userId, type, nickname);
        if (null == result) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"share info is empty");
        }
        return Json.build((Object)result);
    }

    @ApiOperation(value="2-12-11 \u7ea2\u5305\u5899-\u83b7\u53d6\u7ea2\u5305\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u533a\u57df\u7684\u7ea2\u5305\u5217\u8868\uff0c\u6839\u636e\u7528\u6237\u7b5b\u9009\u7ea2\u5305\u53ca\u8bbe\u7f6e\u7ea2\u5305\u72b6\u6001")
    @ApiImplicitParams(value={})
    @GetMapping(value={"/wall"})
    public Json<PageWarper<WallRedPacketDTO>> getWall(WallRedPacketParam wallRedPacketParam) {
        return Json.build((Object)this.redPacketService.getReadPacketWall(wallRedPacketParam));
    }

    @ApiOperation(value="2-12-12 \u83b7\u53d6\u7ea2\u5305\u8be6\u60c5\u4fe1\u606f", notes="\u83b7\u53d6\u7ea2\u5305\u8be6\u60c5\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true), @ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true)})
    @GetMapping(value={"/info"})
    public Json<RedPacketDTO> getRedPacketInfo(@RequestParam(value="userId") Long userId, @RequestParam(value="rpId") Long rpId) {
        return Json.build((Object)this.redPacketService.getReadPacketDetail(userId, rpId));
    }

    @ApiOperation(value="2-12-13 \u83b7\u53d6\u7ea2\u5305\u7684\u6700\u8fd1\u9886\u53d6\u8bb0\u5f55")
    @ApiImplicitParams(value={})
    @GetMapping(value={"/obtainHistory"})
    public Json<PageWarper<PacketHistoryDTO>> getObtainHistory(ObtainHistoryParam obtainHistoryParam) {
        return Json.build((Object)this.redPacketService.getObtainHistory(obtainHistoryParam));
    }

    @ApiOperation(value="2-12-14 \u83b7\u53d6\u8bed\u97f3\u8bc4\u5206\u6392\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true)})
    @GetMapping(value={"/ranklist"})
    public Json<List<PacketHistoryDTO>> getRankList(@RequestParam(value="rpId") Long rpId) {
        return Json.build((Object)this.redPacketService.getRanking(rpId));
    }

    @ApiOperation(value="2-12-15 \u53e3\u4ee4\u8bc4\u5206")
    @ApiImplicitParams(value={})
    @PostMapping(value={"/markScore"})
    public Json<CommandResultDTO> markScore(MarkScoreDTO markScoreDTO, Integer platform) {
        return Json.build((Object)this.redPacketService.markScore(markScoreDTO, platform));
    }

    @ApiOperation(value="2-12-16 \u652f\u4ed8\u67e5\u8be2\u63a5\u53e3", notes="\u67e5\u770b\u652f\u4ed8\u662f\u5426\u6210\u529f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true), @ApiImplicitParam(name="paymentNum", value="\u8ba2\u5355\u7f16\u53f7 \u8fd4\u56de\u72b6\u6001(1\u5f85\u4ed8\u6b3e\uff0c2\u53d6\u6d88\u4ed8\u6b3e\uff0c3\u4ed8\u6b3e\u6210\u529f\uff0c4\u4ed8\u6b3e\u5931\u8d25\uff0c5\u5931\u8d25\u8d85\u65f6)", dataType="String", required=true)})
    @GetMapping(value={"/query/order"})
    public Json<Byte> queryOrder(@RequestParam(value="rpId") Long rpId, @RequestParam(value="userId") Long userId, @RequestParam(value="paymentNum") String paymentNum, BasicParam basicParam) {
        return Json.build((Object)this.redPacketService.queryOrder(rpId, userId, paymentNum, Integer.valueOf(basicParam.getPlatform())));
    }

    @ApiOperation(value="2-12-17 \u8bc4\u5206\u6d4b\u8bd5\u63a5\u53e3(\u524d\u7aef\u52ff\u8c03)", notes="\u8bc4\u5206\u6d4b\u8bd5\u63a5\u53e3(\u524d\u7aef\u52ff\u8c03)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u76ee\u524d\u5f55\u97f3\u5185\u5bb9", dataType="String", required=true), @ApiImplicitParam(name="path", value="\u6587\u4ef6\u5730\u5740", dataType="String", required=true), @ApiImplicitParam(name="len", value="\u5f55\u97f3\u65f6\u957f", dataType="Integer", required=true)})
    @GetMapping(value={"/test/record"})
    public Json<GradeResultBean> testRecord(@RequestParam(value="content") String content, @RequestParam(value="path") String path, @RequestParam(value="len") Integer len) {
        return Json.build((Object)this.commandGradeService.testRecord(content, path, len));
    }

    @ApiOperation(value="2-12-18 \u53e3\u4ee4\u8bc4\u5206\uff08\u7ad9\u5916\uff09")
    @ApiImplicitParams(value={})
    @PostMapping(value={"/public/markScore"})
    public Json<CommandResultDTO> publicMarkScore(MarkScorePublicDTO markScorePublicDTO, Integer platform) {
        return Json.build((Object)this.redPacketService.markScore(markScorePublicDTO, platform));
    }

    @ApiOperation(value="2-12-19 \u53e3\u4ee4\u6700\u5927\u5141\u8bb8\u957f\u5ea6")
    @GetMapping(value={"/commandMaxLength"})
    public Json<Integer> commandMaxLength() {
        return Json.build((Object)this.commandRedPacketProperties.getMaxLength());
    }

    @ApiOperation(value="2-12-20 \u83b7\u53d6\u7ea2\u5305\u8be6\u60c5\u4fe1\u606f\uff08\u7ad9\u5916\uff09", notes="\u83b7\u53d6\u7ea2\u5305\u8be6\u60c5\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u5f53\u524d\u7528\u6237id", dataType="long", required=true), @ApiImplicitParam(name="shareUserId", value="\u5206\u4eab\u4ebaid", dataType="long", required=true), @ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true)})
    @GetMapping(value={"/public/info"})
    public Json<RedPacketPublicDTO> getPublicRedPacketInfo(@RequestParam(value="userId") Long userId, @RequestParam(value="shareUserId") Long shareUserId, @RequestParam(value="rpId") Long rpId) {
        return Json.build((Object)this.redPacketService.getPublicReadPacketDetail(userId, shareUserId, rpId));
    }

    @ApiOperation(value="2-12-21 \u5fae\u4fe1\u8bc4\u5206\u6d4b\u8bd5\u63a5\u53e3(\u524d\u7aef\u52ff\u8c03)", notes="\u8bc4\u5206\u6d4b\u8bd5\u63a5\u53e3(\u524d\u7aef\u52ff\u8c03)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="target", value="\u8bed\u97f3\u6587\u5b57\u5185\u5bb9", dataType="String", required=true), @ApiImplicitParam(name="mediaId", value="\u5fae\u4fe1\u5a92\u4f53\u6587\u4ef6id", dataType="String", required=true)})
    @GetMapping(value={"/test/recordWx"})
    public Json<ScoreDto> testRecordWx(@RequestParam(value="target") String target, @RequestParam(value="mediaId") String mediaId) {
        return Json.build((Object)this.commandGradeService.grade(target, mediaId));
    }

    @ApiOperation(value="2-12-22 \u5f53\u524d\u533a\u57df\u662f\u5426\u4e3a\u53e3\u4ee4\u7ea2\u5305\u6d3b\u52a8\u533a\u57df", notes="\u6839\u636e\u7ea2\u5305\u6240\u5c5e\u533a\u57df\u4e0e\u7528\u6237\u5b9a\u4f4d\u5224\u65ad\u662f\u5426\u4e3a\u7ea2\u5305\u6d3b\u52a8\u533a\u57df")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", required=true), @ApiImplicitParam(name="city", value="\u5e02\u7ea7\u4fe1\u606f", required=false), @ApiImplicitParam(name="district", value="\u533a\u53bf\u7ea7\u4fe1\u606f", required=false)})
    @GetMapping(value={"/public/isActiveArea"})
    public Json<Boolean> isActiveArea(@RequestParam(name="rpId") Long rpId, @RequestParam(name="city") String city, @RequestParam(name="district") String district) {
        return ResultUtil.genSuccessResult((Object)this.redPacketService.isActiveArea(rpId, city, district));
    }

    @ApiOperation(value="2-12-23 \u7ea2\u5305\u5899-\u83b7\u53d6\u5355\u4e2a\u7ea2\u5305", notes="\u901a\u8fc7\u7528\u6237id\u548c\u7ea2\u5305id \u83b7\u53d6\u8be5\u7528\u6237\u4e0e\u8be5\u7ea2\u5305\u7684\u72b6\u6001\uff0c\u53ca\u7ea2\u5305\u7684\u5c5e\u6027")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u5f53\u524d\u7528\u6237id", dataType="long", required=true), @ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true)})
    @GetMapping(value={"/wall/single"})
    public Json<WallRedPacketDTO> getSingleWall(Long userId, Long rpId) {
        return Json.build((Object)this.redPacketService.getSingleWallReadPacket(userId, rpId));
    }

    @ApiOperation(value="2-12-24 \u83b7\u53d6\u7ea2\u5305\u7684\u6700\u8fd1\u9886\u53d6\u8bb0\u5f55(\u7ad9\u5916)")
    @ApiImplicitParams(value={})
    @GetMapping(value={"/public/obtainHistory"})
    public Json<PageWarper<PacketHistoryDTO>> getObtainHistoryPublic(ObtainHistoryParam obtainHistoryParam) {
        return Json.build((Object)this.redPacketService.getObtainHistory(obtainHistoryParam));
    }

    @ApiOperation(value="2-12-25 \u83b7\u53d6\u8bed\u97f3\u8bc4\u5206\u6392\u540d(\u7ad9\u5916)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true)})
    @GetMapping(value={"/public/ranklist"})
    public Json<List<PacketHistoryDTO>> getRankListPublic(@RequestParam(value="rpId") Long rpId) {
        return Json.build((Object)this.redPacketService.getRanking(rpId));
    }

    @ApiOperation(value="2-12-26 \u83b7\u53d6\u5206\u4eab\u4fe1\u606f\u63a5\u53e3(\u7ad9\u5916)", notes="\u7ad9\u5916\u83b7\u53d6\u7528\u4e8e\u5206\u4eab\u7684\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="long", required=true), @ApiImplicitParam(name="type", value="\u7c7b\u578b\uff081\uff1a\u672a\u53c2\u4e0e\u30012\uff1a\u5df2\u53c2\u4e0e\uff09", dataType="int", required=true), @ApiImplicitParam(name="nickname", value="\u5206\u4eab\u4eba\u6635\u79f0", dataType="string", required=true)})
    @PostMapping(value={"/get/public/share"})
    public Json<RedPacketShareDTO> getShareInfoPublic(@RequestParam(value="rpId") Long rpId, @RequestParam(value="userId") Long userId, @RequestParam(value="type") Integer type, @RequestParam(value="nickname") String nickname) {
        RedPacketShareDTO result = this.redPacketService.getShareInfo(rpId, userId, type, nickname);
        if (null == result) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"share info is empty");
        }
        return Json.build((Object)result);
    }

    @ApiOperation(value="2-12-27 \u67e5\u8be2\u7ea2\u5305\u652f\u4ed8\u72b6\u6001(H5\u8c03)", notes="\u652f\u4ed8\u6210\u529f\uff1atrue,\u652f\u4ed8\u5931\u8d25:false")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rpId", value="\u7ea2\u5305id", dataType="long", required=true)})
    @PostMapping(value={"/get/isPaySuccess"})
    public Json<Boolean> isPaySuccess(@RequestParam(value="rpId") Long rpId) {
        return Json.build((Object)this.redPacketService.isPaySuccess(rpId));
    }
}

