package com.bxm.localnews.activity.common.constant;

import java.util.Arrays;

/**
 * Created by Arei on 2018/10/20.
 */
public enum PrivilegeStatusEnum {
    PROCESSING(3), WAIT_TO_START(2), END(1), CANCEL(0);
    private Integer status;

    PrivilegeStatusEnum(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return status;
    }

    public static PrivilegeStatusEnum getEnumByStatus(Integer status) {
        return Arrays.asList(PrivilegeStatusEnum.values()).stream().filter(
                privilegeStatusEnum -> status == privilegeStatusEnum.getStatus()
        ).findAny().orElse(null);
    }
}
