package com.bxm.localnews.activity.common.constant;

/**
 * Created by Administrator on 2018/2/24.
 */
public enum TaskTypeEnum {

    BIND_WEIXIN((byte) 1, "绑定微信", new String[]{"otherReward", "goldReward"}),
    RECRUIT_FIRST((byte) 2, "首次收徒", new String[]{"recruitMoney", "moneyReward"}),
    PUSH_NEWS_OPEN((byte) 3, "开启新闻推送通知", new String[]{"otherReward", "goldReward"}),
    MATCHES_CONTACTS((byte) 4, "匹配通讯录", new String[]{"otherReward", "goldReward"}),
    APPRENTICE((byte) 5, "拜师学艺", new String[]{"moneyReward", "redPacketMoney"}),
    ADD_RECRUIT((byte) 6, "邀请收徒", new String[]{"recruitMoney", "moneyReward",}),
    ADD_DISCIPLE((byte) 7, "收取徒孙", new String[]{"discipleReward", "moneyReward", "redPacketMoney"}),
    FRIEND_READ((byte) 8, "好友阅读", new String[]{"articalReadByShare", "goldReward"}),
    SHARE_ARTICLE((byte) 9, "分享新闻", new String[]{"shareArtical", "goldReward"}),

    READ_ARTICLE((byte) 10, "阅读新闻", new String[]{"readReward", "tribute", "goldReward"}),
    READ_PUSH_ARTICLE((byte) 11, "阅读推送新闻", new String[]{"otherReward", "goldReward"}),
    DIVULGE_INCOME((byte) 12, "晒收入", new String[]{"showIncome", "goldReward"}),
    ECRUIT_BY_SHARE_FRIEND((byte) 13, "分享到朋友圈收徒", new String[]{"otherReward", "goldReward"}),
    ECRUIT_BY_SHARE_WEIXIN((byte) 14, "分享到微信收徒", new String[]{"otherReward", "goldReward"}),

    AWAKE_PUPIL((byte) 15, "唤醒徒儿", new String[]{"otherReward", "goldReward"}),
    QUESTIONAIRE_REWARD((byte) 16, "有奖问卷", new String[]{"otherReward", "goldReward"}),
    GOOD_ADVICE_REWARD((byte) 17, "优质建议奖", new String[]{"otherReward", "goldReward"}),
    REGISTER((byte) 18, "用户注册", new String[]{"moneyReward", "redPacketMoney"}),
    MONEY_TREE((byte) 19, "摇钱树", new String[]{"otherReward", "goldReward"}),
    SIGN_DAILY((byte) 20, "每日签到", new String[]{"otherReward", "goldReward"}),
    EARNING_BY_TRIBUTE((byte) 21, "徒儿进贡", new String[]{"totalTribute", "goldReward"}),
    MEONEY_TREE_BY_SHARE((byte) 22, "分享摇钱树到朋友圈", new String[]{"otherReward", "goldReward"}),
    LEVEL_REWARD_PER_MONTH((byte) 23, "用户等级每月奖励", new String[]{"otherReward", "goldReward"}),
    GOLD_CONVERT_TO_COIN((byte) 24, "金币兑换成零钱", new String[]{"moneyReward", "convertMoney"}),
    RED_PACKAGE((byte) 25, "红包邀请注册", new String[]{"moneyReward", "redPacketMoney"}),
    RED_PACKAGE_LEVEL((byte) 26, "红包邀请奖励", new String[]{"otherReward", "goldReward"}),
    BALANCE_EXCHANGE_GOODS((byte) 27, "金币兑换商品", new String[]{"otherReward", "goldReward"}),
    STORE_ADD_BALANCE((byte) 30, "积分商城添加金币", new String[]{"otherReward", "goldReward"}),
    INVITE_USER((byte) 28, "邀请新用户", new String[]{"otherReward", "goldReward"}),
    NEW_INVITED_USER((byte) 29, "被邀请的新用户", new String[]{"otherReward", "goldReward"}),
    TASK_INVITED_FRIEND((byte) 30, "邀请好友", new String[]{"otherReward", "goldReward"}),
    TASK_NEWS_READ((byte) 31, "看新闻", new String[]{"", ""}),
    TASK_VIDEO_READ((byte) 32, "看视频", new String[]{"", ""}),
    TASK_NEWS_SHARE((byte) 33, "分享", new String[]{"", ""});




    private byte type;

    private String desc;

    /**
     * 每日统计表中需要变化的列
     */
    private String[] tableColumn;

    TaskTypeEnum(byte type, String desc, String[] tableColumn) {
        this.type = type;
        this.desc = desc;
        this.tableColumn = tableColumn;
    }

    public static String getDescByType(byte type) {
        for (TaskTypeEnum taskTypeEnum : TaskTypeEnum.values()) {
            if (taskTypeEnum.getType() == type) {
                return taskTypeEnum.getDesc();
            }
        }
        return null;
    }

    public static String[] getTableColumByType(byte type) {
        for (TaskTypeEnum taskTypeEnum : TaskTypeEnum.values()) {
            if (taskTypeEnum.getType() == type) {
                return taskTypeEnum.getTableColumn();
            }
        }
        return null;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String[] getTableColumn() {
        return this.tableColumn;
    }

    public void setTableColumn(String[] tableColumn) {
        this.tableColumn = tableColumn;
    }
}
