package com.bxm.localnews.activity.common.config;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
@Data
@ConfigurationProperties("activity.config")
public class ActivityProperties {

    /**
     * 设备验证token
     */
    private String machineToken;

    /**
     * 设备接入码
     */
    private String machineEncodingAESKey;

    /**
     * 机器对应的appid
     */
    private String machineAppId;

    /**
     * 分享到朋友圈的拉新图片的原图
     */
    private String shareSourceImgUrl;

    /**
     * 百度AI AppId
     */
    private String baiduAiAppId;

    /**
     * 百度AI API KEY
     */
    private String baiduAiApiKey;

    /**
     * 百度AI SecretKey
     */
    private String baiduAiSecretKey;

    /**
     * 商家列表权重
     */
    Map<String, String> weight = Maps.newHashMap();

    /**
     * 淘气365商城的用户ID
     */
    private String taoqi365AgentId = "817";

    /**
     * 淘气365商城，不参与签名的字段
     */
    private String[] excludeParam = {"id", "singleSign", "querySign"};

    /**
     * 淘气365商城的密钥
     */
    private String taoqi365SecertKey = "ZrNN4BFmyzXSDMJbpYQ3YfsxShkJaQwK";

    /**
     * 榜单模块开关
     */
    private Map<String, Boolean> rankType;

    /**
     * 互动榜单黑名单,放置用户id  （不做为全局榜单黑名单，如果有需要，需要单独分榜设置黑名单，此处只作为互动榜黑名单）
     */
    List<Long> interactRankBlack;

    /**
     * 发帖榜黑名单
     */
    List<Long> forumRankBlack;

    /**
     * 收徒榜黑名单
     */
    List<Long> inviteRankBlack;
}
