package com.bxm.localnews.activity.common.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

@Component
@Data
@ConfigurationProperties("activity.help.info")
public class HelpInfoProperties {

    //活动开关
    private Integer state;

    //活动区域
    private String activeArea;

    //换算比率
    private BigDecimal helpRate;

    //爱心节点
    private Integer helpPoint;

    //总助力次数限制
    private Integer helpTotalLimit;

    //活动开始时间
    private String startTime;

    //活动结束时间
    private String endTime;


    //助力版块id
    private Long forumId;

    //团队默认头像
    private String defaultTeamImg;



    /**
     * 帖子详情页
     */
    private String postDetail;

}
